/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.java;

import io.github.ascopes.protobufmavenplugin.java.JavaApp;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@Generated(from="JavaApp", generator="Immutables")
public final class ImmutableJavaApp
implements JavaApp {
    private final @Nullable String uniqueName;
    private final List<Path> dependencies;
    private final @Nullable List<String> jvmArgs;
    private final @Nullable List<String> jvmConfigArgs;
    private final @Nullable String mainClass;

    private ImmutableJavaApp(Builder builder) {
        this.uniqueName = builder.uniqueName;
        this.dependencies = builder.dependencies == null ? Collections.emptyList() : ImmutableJavaApp.createUnmodifiableList(true, builder.dependencies);
        this.jvmArgs = builder.jvmArgs == null ? null : ImmutableJavaApp.createUnmodifiableList(true, builder.jvmArgs);
        this.jvmConfigArgs = builder.jvmConfigArgs == null ? null : ImmutableJavaApp.createUnmodifiableList(true, builder.jvmConfigArgs);
        this.mainClass = builder.mainClass;
    }

    @Override
    public @Nullable String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public List<Path> getDependencies() {
        return this.dependencies;
    }

    @Override
    public @Nullable List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public @Nullable List<String> getJvmConfigArgs() {
        return this.jvmConfigArgs;
    }

    @Override
    public @Nullable String getMainClass() {
        return this.mainClass;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJavaApp && this.equalsByValue((ImmutableJavaApp)another);
    }

    private boolean equalsByValue(ImmutableJavaApp another) {
        return Objects.equals(this.uniqueName, another.uniqueName) && this.dependencies.equals(another.dependencies) && Objects.equals(this.jvmArgs, another.jvmArgs) && Objects.equals(this.jvmConfigArgs, another.jvmConfigArgs) && Objects.equals(this.mainClass, another.mainClass);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.uniqueName);
        h += (h << 5) + this.dependencies.hashCode();
        h += (h << 5) + Objects.hashCode(this.jvmArgs);
        h += (h << 5) + Objects.hashCode(this.jvmConfigArgs);
        h += (h << 5) + Objects.hashCode(this.mainClass);
        return h;
    }

    public String toString() {
        return "JavaApp{uniqueName=" + this.uniqueName + ", dependencies=" + String.valueOf(this.dependencies) + ", jvmArgs=" + String.valueOf(this.jvmArgs) + ", jvmConfigArgs=" + String.valueOf(this.jvmConfigArgs) + ", mainClass=" + this.mainClass + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="JavaApp", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_UNIQUE_NAME = 1L;
        private long initBits = 1L;
        private @Nullable String uniqueName;
        private @Nullable List<Path> dependencies = null;
        private @Nullable List<String> jvmArgs = null;
        private @Nullable List<String> jvmConfigArgs = null;
        private @Nullable String mainClass;

        private Builder() {
        }

        public final Builder from(JavaApp instance) {
            String mainClassValue;
            List<String> jvmConfigArgsValue;
            Objects.requireNonNull(instance, "instance");
            String uniqueNameValue = instance.getUniqueName();
            if (uniqueNameValue != null) {
                this.uniqueName(uniqueNameValue);
            }
            this.addAllDependencies(instance.getDependencies());
            @Nullable List<String> jvmArgsValue = instance.getJvmArgs();
            if (jvmArgsValue != null) {
                this.addAllJvmArgs(jvmArgsValue);
            }
            if ((jvmConfigArgsValue = instance.getJvmConfigArgs()) != null) {
                this.addAllJvmConfigArgs(jvmConfigArgsValue);
            }
            if ((mainClassValue = instance.getMainClass()) != null) {
                this.mainClass(mainClassValue);
            }
            return this;
        }

        public final Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addDependencies(@Nullable Path element) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Path>();
            }
            this.dependencies.add(element);
            return this;
        }

        public final Builder addDependencies(Path ... elements) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.dependencies.add(element);
            }
            return this;
        }

        public final Builder dependencies(Iterable<? extends @Nullable Path> elements) {
            this.dependencies = new ArrayList<Path>();
            return this.addAllDependencies(elements);
        }

        public final Builder addAllDependencies(Iterable<? extends @Nullable Path> elements) {
            Objects.requireNonNull(elements, "dependencies element");
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.dependencies.add(path);
            }
            return this;
        }

        public final Builder addJvmArgs(@Nullable String element) {
            if (this.jvmArgs == null) {
                this.jvmArgs = new ArrayList<String>();
            }
            this.jvmArgs.add(element);
            return this;
        }

        public final Builder addJvmArgs(String ... elements) {
            if (this.jvmArgs == null) {
                this.jvmArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmArgs.add(element);
            }
            return this;
        }

        public final Builder jvmArgs(@Nullable Iterable<@Nullable String> elements) {
            if (elements == null) {
                this.jvmArgs = null;
                return this;
            }
            this.jvmArgs = new ArrayList<String>();
            return this.addAllJvmArgs(elements);
        }

        public final Builder addAllJvmArgs(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "jvmArgs element");
            if (this.jvmArgs == null) {
                this.jvmArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmArgs.add(element);
            }
            return this;
        }

        public final Builder addJvmConfigArgs(@Nullable String element) {
            if (this.jvmConfigArgs == null) {
                this.jvmConfigArgs = new ArrayList<String>();
            }
            this.jvmConfigArgs.add(element);
            return this;
        }

        public final Builder addJvmConfigArgs(String ... elements) {
            if (this.jvmConfigArgs == null) {
                this.jvmConfigArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmConfigArgs.add(element);
            }
            return this;
        }

        public final Builder jvmConfigArgs(@Nullable Iterable<@Nullable String> elements) {
            if (elements == null) {
                this.jvmConfigArgs = null;
                return this;
            }
            this.jvmConfigArgs = new ArrayList<String>();
            return this.addAllJvmConfigArgs(elements);
        }

        public final Builder addAllJvmConfigArgs(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "jvmConfigArgs element");
            if (this.jvmConfigArgs == null) {
                this.jvmConfigArgs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.jvmConfigArgs.add(element);
            }
            return this;
        }

        public final Builder mainClass(@Nullable String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public ImmutableJavaApp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJavaApp(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("uniqueName");
            }
            return "Cannot build JavaApp, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

