/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.PlatformClassifierFactory;
import io.github.ascopes.protobufmavenplugin.digests.Digest;
import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.java.ImmutableJavaApp;
import io.github.ascopes.protobufmavenplugin.java.JavaAppToExecutableFactory;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryMavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableBinaryMavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.JvmMavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.PathProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.UriProtocPlugin;
import io.github.ascopes.protobufmavenplugin.urls.UriResourceFetcher;
import io.github.ascopes.protobufmavenplugin.utils.ConcurrentExecutor;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.SystemPathBinaryResolver;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Resolves and packages protoc plugins from various remote and local locations")
@MojoExecutionScoped
@Named
public final class ProtocPluginResolver {
    private static final Logger log = LoggerFactory.getLogger(ProtocPluginResolver.class);
    private final ConcurrentExecutor concurrentExecutor;
    private final MavenArtifactPathResolver artifactPathResolver;
    private final PlatformClassifierFactory platformClassifierFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UriResourceFetcher urlResourceFetcher;
    private final JavaAppToExecutableFactory javaAppToExecutableFactory;

    @Inject
    ProtocPluginResolver(ConcurrentExecutor concurrentExecutor, MavenArtifactPathResolver artifactPathResolver, PlatformClassifierFactory platformClassifierFactory, SystemPathBinaryResolver systemPathResolver, UriResourceFetcher urlResourceFetcher, JavaAppToExecutableFactory javaAppToExecutableFactory) {
        this.concurrentExecutor = concurrentExecutor;
        this.artifactPathResolver = artifactPathResolver;
        this.platformClassifierFactory = platformClassifierFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
        this.javaAppToExecutableFactory = javaAppToExecutableFactory;
    }

    public Collection<ResolvedProtocPlugin> resolvePlugins(GenerationRequest request) throws ResolutionException {
        List<ProtocPlugin> requestedPlugins = request.getProtocPlugins();
        Stream.Builder<FutureTask<Optional<ResolvedProtocPlugin>>> futures = Stream.builder();
        for (int index = 0; index < requestedPlugins.size(); ++index) {
            futures.accept(this.resolvePluginSoon(requestedPlugins.get(index), request.getOutputDirectory(), index));
        }
        return futures.build().collect(this.concurrentExecutor.awaiting()).stream().flatMap(Optional::stream).toList();
    }

    private FutureTask<Optional<ResolvedProtocPlugin>> resolvePluginSoon(ProtocPlugin plugin, Path defaultOutputDirectory, int index) {
        return this.concurrentExecutor.submit(() -> {
            if (plugin instanceof BinaryMavenProtocPlugin) {
                BinaryMavenProtocPlugin pluginImpl = (BinaryMavenProtocPlugin)plugin;
                return this.resolveBinaryMavenPlugin(pluginImpl, defaultOutputDirectory, index);
            }
            if (plugin instanceof PathProtocPlugin) {
                PathProtocPlugin pluginImpl = (PathProtocPlugin)plugin;
                return this.resolveBinaryPathPlugin(pluginImpl, defaultOutputDirectory, index);
            }
            if (plugin instanceof UriProtocPlugin) {
                UriProtocPlugin pluginImpl = (UriProtocPlugin)plugin;
                return this.resolveBinaryUrlPlugin(pluginImpl, defaultOutputDirectory, index);
            }
            if (plugin instanceof JvmMavenProtocPlugin) {
                JvmMavenProtocPlugin pluginImpl = (JvmMavenProtocPlugin)plugin;
                return this.resolveJvmMavenPlugin(pluginImpl, defaultOutputDirectory, index);
            }
            throw new UnsupportedOperationException();
        });
    }

    private Optional<ResolvedProtocPlugin> resolveBinaryMavenPlugin(BinaryMavenProtocPlugin plugin, Path defaultOutputDirectory, int index) throws ResolutionException {
        ImmutableBinaryMavenProtocPlugin.Builder pluginBuilder = ImmutableBinaryMavenProtocPlugin.builder().from(plugin);
        if (plugin.getClassifier() == null) {
            String classifier = this.platformClassifierFactory.getClassifier(plugin.getArtifactId());
            pluginBuilder.classifier(classifier);
        }
        if (plugin.getType() == null) {
            pluginBuilder.type("exe");
        }
        plugin = pluginBuilder.build();
        log.debug("Resolving binary Maven protoc plugin \"{}\"", (Object)plugin);
        Path path = this.artifactPathResolver.resolveExecutable(plugin);
        String id = this.computeId(path, index);
        return Optional.of(this.createResolvedProtocPlugin(plugin, defaultOutputDirectory, path, id));
    }

    private Optional<ResolvedProtocPlugin> resolveBinaryPathPlugin(PathProtocPlugin plugin, Path defaultOutputDirectory, int index) throws ResolutionException {
        log.debug("Resolving binary path protoc plugin \"{}\"", (Object)plugin);
        Optional<Path> maybePath = this.systemPathResolver.resolve(plugin.getName());
        if (maybePath.isEmpty() && plugin.isOptional()) {
            return Optional.empty();
        }
        Path path = maybePath.orElseThrow(() -> new ResolutionException("No plugin named \"" + plugin.getName() + "\" was found on the system path"));
        String id = this.computeId(path, index);
        return Optional.of(this.createResolvedProtocPlugin(plugin, defaultOutputDirectory, path, id));
    }

    private Optional<ResolvedProtocPlugin> resolveBinaryUrlPlugin(UriProtocPlugin plugin, Path defaultOutputDirectory, int index) throws ResolutionException {
        log.debug("Resolving binary URL protoc plugin \"{}\"", (Object)plugin);
        Optional<Path> maybePath = this.urlResourceFetcher.fetchFileFromUri(plugin.getUrl(), ".exe", true);
        if (maybePath.isEmpty() && plugin.isOptional()) {
            return Optional.empty();
        }
        Path path = maybePath.orElseThrow(() -> new ResolutionException("Plugin at " + String.valueOf(plugin.getUrl()) + " does not exist"));
        if (plugin.getDigest() != null) {
            log.debug("Verifying digest of \"{}\" against \"{}\"", (Object)plugin.getUrl(), (Object)plugin.getDigest());
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                plugin.getDigest().verify(is);
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to compute digest of \"" + String.valueOf(plugin.getUrl()) + "\": " + String.valueOf(ex), ex);
            }
        }
        String id = this.computeId(path, index);
        return Optional.of(this.createResolvedProtocPlugin(plugin, defaultOutputDirectory, path, id));
    }

    private Optional<ResolvedProtocPlugin> resolveJvmMavenPlugin(JvmMavenProtocPlugin plugin, Path defaultOutputDirectory, int index) throws ResolutionException {
        log.debug("Resolving JVM-based Maven protoc plugin \"{}\" and generating bootstrap scripts", (Object)plugin);
        try {
            List dependencies = this.artifactPathResolver.resolveDependencies(List.of(plugin), DependencyResolutionDepth.TRANSITIVE, Set.of("compile", "runtime", "system"), false).stream().toList();
            String id = this.computeId((Path)dependencies.get(0), index);
            ImmutableJavaApp app = ImmutableJavaApp.builder().addAllDependencies(dependencies).jvmArgs(plugin.getJvmArgs()).jvmConfigArgs(plugin.getJvmConfigArgs()).mainClass(plugin.getMainClass()).uniqueName(id).build();
            Path path = this.javaAppToExecutableFactory.toExecutable(app);
            return Optional.of(this.createResolvedProtocPlugin(plugin, defaultOutputDirectory, path, id));
        }
        catch (ResolutionException ex) {
            throw new ResolutionException("Failed to resolve protoc plugin " + String.valueOf(plugin) + ": " + String.valueOf(ex), ex);
        }
    }

    private ResolvedProtocPlugin createResolvedProtocPlugin(ProtocPlugin plugin, Path defaultOutputDirectory, Path path, String id) {
        return ImmutableResolvedProtocPlugin.builder().id(id).options(plugin.getOptions()).order(plugin.getOrder()).outputDirectory(Objects.requireNonNullElse(plugin.getOutputDirectory(), defaultOutputDirectory)).path(path).build();
    }

    private String computeId(Path path, int index) {
        return index + "_" + Digest.compute("SHA-1", path.toString()).toHexString();
    }
}

