/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources.incremental;

import io.github.ascopes.protobufmavenplugin.sources.incremental.ImmutableIncrementalCache;
import io.github.ascopes.protobufmavenplugin.sources.incremental.IncrementalCache;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.json.JSONObject;
import org.json.JSONTokener;

@Description(value="Serializes and deserializes incremental cache files")
@MojoExecutionScoped
@Named
final class IncrementalCacheSerializer {
    private static final String PROTO_DEPENDENCIES = "proto_dependencies";
    private static final String PROTO_SOURCES = "proto_sources";
    private static final String DESCRIPTOR_FILES = "descriptor_files";

    IncrementalCacheSerializer() {
    }

    void serialize(IncrementalCache cache, Writer writer) throws IOException {
        try {
            new JSONObject().put(PROTO_DEPENDENCIES, (Object)this.pathMappingToJson(cache.getProtoDependencies())).put(PROTO_SOURCES, (Object)this.pathMappingToJson(cache.getProtoSources())).put(DESCRIPTOR_FILES, (Object)this.pathMappingToJson(cache.getDescriptorFiles())).write(writer, 2, 2);
        }
        catch (Exception ex) {
            throw new IOException("Failed to write JSON file", ex);
        }
    }

    IncrementalCache deserialize(Reader reader) throws IOException {
        try {
            JSONObject object = new JSONObject(new JSONTokener(reader));
            return ImmutableIncrementalCache.builder().protoDependencies(this.jsonToPathMapping(object.getJSONObject(PROTO_DEPENDENCIES))).protoSources(this.jsonToPathMapping(object.getJSONObject(PROTO_SOURCES))).descriptorFiles(this.jsonToPathMapping(object.getJSONObject(DESCRIPTOR_FILES))).build();
        }
        catch (Exception ex) {
            throw new IOException("Failed to read JSON file", ex);
        }
    }

    private JSONObject pathMappingToJson(Map<Path, String> mapping) {
        JSONObject object = new JSONObject();
        mapping.forEach((path, hash) -> object.put(path.toUri().toASCIIString(), hash));
        return object;
    }

    private Map<Path, String> jsonToPathMapping(JSONObject object) {
        LinkedHashMap mapping = new LinkedHashMap();
        object.keys().forEachRemaining(path -> {
            String hash = object.getString(path);
            mapping.put(Path.of(URI.create(path)), hash);
        });
        return Collections.unmodifiableMap(mapping);
    }
}

