/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.fs.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Discovers executables on the system-path using OS-aware resolution techniques")
@MojoExecutionScoped
@Named
public final class SystemPathBinaryResolver {
    private static final Logger log = LoggerFactory.getLogger(SystemPathBinaryResolver.class);
    private final HostSystem hostSystem;

    @Inject
    public SystemPathBinaryResolver(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Path> resolve(String name) throws ResolutionException {
        log.debug("Looking for executable matching name \"{}\" on PATH", (Object)name);
        Predicate<Path> predicate = this.hostSystem.isProbablyWindows() ? this.isWindowsMatch(name) : this.isPosixMatch(name);
        try {
            for (Path dir : this.hostSystem.getSystemPath()) {
                try {
                    Stream<Path> files = Files.walk(dir, 1, new FileVisitOption[0]);
                    try {
                        Optional<Path> result = files.filter(predicate).findFirst();
                        if (!result.isPresent()) continue;
                        log.debug("Result for lookup of \"{}\" on PATH was \"{}\"", (Object)name, (Object)result.get());
                        Optional<Path> optional = result;
                        return optional;
                    }
                    finally {
                        if (files == null) continue;
                        files.close();
                    }
                }
                catch (AccessDeniedException ex) {
                    log.debug("Ignoring directory \"{}\" as access is denied", (Object)dir, (Object)ex);
                }
            }
        }
        catch (Exception ex) {
            throw new ResolutionException("An exception occurred while scanning the system PATH: " + String.valueOf(ex), ex);
        }
        log.debug("No match found for \"{}\" on PATH", (Object)name);
        return Optional.empty();
    }

    private Predicate<Path> isPosixMatch(String name) {
        return path -> path.getFileName().toString().equals(name) && Files.isExecutable(path);
    }

    private Predicate<Path> isWindowsMatch(String name) {
        NavigableSet<String> pathExtensions = this.hostSystem.getSystemPathExtensions();
        return path -> {
            String fileName = FileUtils.getFileNameWithoutExtension(path);
            Optional<String> fileExtension = FileUtils.getFileExtension(path);
            if (!fileName.equalsIgnoreCase(name)) return false;
            if (!fileExtension.filter(pathExtensions::contains).isPresent()) return false;
            return true;
        };
    }
}

