/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class PhantomJsDriverManager
extends WebDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.PHANTOMJS;
    }

    @Override
    protected String getDriverName() {
        return "phantomjs";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getPhantomjsDriverVersion();
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getPhantomjsDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getPhantomjsDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getPhantomjsDriverExport());
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setPhantomjsDriverVersion(driverVersion);
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setPhantomjsDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls() throws IOException {
        return this.getDriversFromBitBucket();
    }

    @Override
    protected String getCurrentVersion(URL url) {
        int matchIndex;
        String driverName = this.getDriverName();
        String file = url.getFile();
        file = url.getFile().substring(file.lastIndexOf("/"), file.length());
        String currentVersion = file.substring((matchIndex = file.indexOf(driverName)) + driverName.length() + 1, file.length());
        int dashIndex = currentVersion.indexOf(45);
        if (dashIndex != -1) {
            String beta = currentVersion.substring(dashIndex + 1, dashIndex + 1 + "beta".length());
            if (beta.equalsIgnoreCase("beta")) {
                dashIndex = currentVersion.indexOf(45, dashIndex + 1);
            }
            currentVersion = dashIndex != -1 ? currentVersion.substring(0, dashIndex) : "";
        } else {
            currentVersion = "";
        }
        return currentVersion;
    }

    @Override
    protected File postDownload(File archive) {
        log.trace("PhantomJS package name: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles(this.getFolderFilter())[0];
        log.trace("PhantomJS extract folder (to be deleted): {}", (Object)extractFolder);
        File binFolder = new File(extractFolder.getAbsoluteFile() + File.separator + "bin");
        int driverIndex = 0;
        if (!binFolder.exists()) {
            binFolder = extractFolder;
            driverIndex = 3;
        }
        log.trace("PhantomJS bin folder: {} (index {})", (Object)binFolder, (Object)driverIndex);
        File phantomjs = binFolder.listFiles()[driverIndex];
        log.trace("PhantomJS driver: {}", (Object)phantomjs);
        File target = new File(archive.getParentFile().getAbsolutePath(), phantomjs.getName());
        log.trace("PhantomJS target: {}", (Object)target);
        this.downloader.renameFile(phantomjs, target);
        this.downloader.deleteFolder(extractFolder);
        return target;
    }

    @Override
    protected Optional<String> getBrowserVersionFromTheShell() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return Optional.empty();
    }

    @Override
    protected String getBrowserVersion() {
        return "";
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
    }
}

