/*
 * Decompiled with CFR 0.152.
 */
package io.github.coffeelibs.tinyoauth2client.http.response;

import io.github.coffeelibs.tinyoauth2client.http.response.EmptyResponse;
import io.github.coffeelibs.tinyoauth2client.http.response.HtmlResponse;
import io.github.coffeelibs.tinyoauth2client.http.response.RedirectResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.jetbrains.annotations.Contract;

public interface Response {
    public void write(Writer var1) throws IOException;

    @Contract(value="!null -> new")
    public static Response empty(Status status) {
        return new EmptyResponse(status);
    }

    @Contract(value="!null, !null -> new")
    public static Response html(Status status, String body) {
        return new HtmlResponse(status, body);
    }

    @Contract(value="!null -> new")
    public static Response redirect(URI target) {
        return new RedirectResponse(Status.SEE_OTHER, target);
    }

    public static enum Status {
        OK(200, "OK"),
        SEE_OTHER(303, "See Other"),
        BAD_REQUEST(400, "Bad Request"),
        NOT_FOUND(404, "Not Found"),
        METHOD_NOT_ALLOWED(405, "Method not Allowed");

        public final int code;
        public final String reason;

        private Status(int code, String reason) {
            this.code = code;
            this.reason = reason;
        }
    }
}

