/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023-2024 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

/**
 * A GitHub Security Advisory Reference.
 * 
 * <pre>
 * type SecurityAdvisoryReference
 * </pre>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Reference implements Serializable {

    /**
     * Serialization version UID.
     */
    private static final long serialVersionUID = 1985278256776999313L;
    @JsonProperty("url")
    private String url;

    /**
     * Returns a publicly accessible reference.
     *
     * @return a publicly accessible reference.
     */
    public String getUrl() {
        return url;
    }

    @Override
    public String toString() {
        return "Reference{" + "url='" + url + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        Reference reference = (Reference) o;
        return Objects.equals(url, reference.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url);
    }
}
