/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;

public class TagLibrary {
    public static final String METHOD_GET_PREFIX = "get";
    public static final int METHOD_GET_PREFIX_SIZE = "get".length();
    public static final String METHOD_IS_PREFIX = "is";
    public static final int METHOD_IS_PREFIX_SIZE = "is".length();
    private final List<Tag> tags = new ArrayList<Tag>();
    private final Set<DataObject> schemaObjects = new HashSet<DataObject>();
    private final Set<String> exploredSignatures = new HashSet<String>();
    final Map<Class, DataObject> classToSchemaObject = new HashMap<Class, DataObject>();

    public void addTag(Tag tag) throws MojoFailureException {
        this.tags.add(tag);
        this.exploreTagObjects(tag);
    }

    public void addExtraClass(Class clazz) {
        DataObject dataObject = new DataObject(clazz);
        this.exploreDataObject(dataObject);
    }

    private void exploreTagObjects(Tag tag) {
        for (Endpoint endpoint : tag.getEndpoints()) {
            if (endpoint.getResponseObject() != null) {
                this.exploreDataObject(endpoint.getResponseObject());
            }
            for (ParameterObject parameterObject : endpoint.getParameters()) {
                this.exploreDataObject(parameterObject);
            }
        }
    }

    private void exploreDataObject(DataObject dataObject) {
        if (!this.exploredSignatures.add(dataObject.getSignature())) {
            return;
        }
        if (dataObject.isReferenceObject()) {
            if (this.schemaObjects.add(dataObject)) {
                this.inspectObject(dataObject);
            }
        } else if (dataObject.isGenericallyTyped()) {
            if (dataObject.getGenericNameToTypeMap() != null) {
                for (Map.Entry<String, Type> entry : dataObject.getGenericNameToTypeMap().entrySet()) {
                    DataObject genericObject = new DataObject(dataObject.getContextualType(entry.getValue()));
                    this.exploreDataObject(genericObject);
                }
            }
            this.inspectObject(dataObject);
        } else if (dataObject.isJavaArray()) {
            this.exploreDataObject(dataObject.getArrayItemDataObject());
        }
    }

    private void inspectObject(DataObject explored) {
        if (explored.getJavaClass().isEnum() || explored.getOpenApiResolvedType().isCompleteNode()) {
            return;
        }
        List<Field> fields = ReflectionsUtils.getAllNonStaticFields(new ArrayList<Field>(), explored.getJavaClass());
        for (Field field : fields) {
            if (field.isAnnotationPresent(JsonIgnore.class)) continue;
            DataObject dataObject = new DataObject(explored.getContextualType(field.getGenericType()));
            this.exploreDataObject(dataObject);
        }
        if (explored.getJavaClass().isInterface()) {
            Method[] methods;
            for (Method method : methods = explored.getJavaClass().getMethods()) {
                if (method.getParameters().length != 0 || (!method.getName().startsWith(METHOD_GET_PREFIX) || method.getName().length() == METHOD_GET_PREFIX_SIZE) && (!method.getName().startsWith(METHOD_IS_PREFIX) || method.getName().length() == METHOD_IS_PREFIX_SIZE)) continue;
                DataObject dataObject = new DataObject(explored.getContextualType(method.getGenericReturnType()));
                this.exploreDataObject(dataObject);
            }
        }
    }

    public Collection<Tag> getTags() {
        return this.tags;
    }

    public Collection<Tag> getSortedTags() {
        return this.tags.stream().sorted().collect(Collectors.toList());
    }

    public Set<DataObject> getSchemaObjects() {
        return this.schemaObjects;
    }

    public Map<Class, DataObject> getClassToSchemaObject() {
        return this.classToSchemaObject;
    }

    public void resolveSchemaReferenceNames() {
        HashSet<String> referenceNames = new HashSet<String>();
        List orderedSchemaObjects = this.schemaObjects.stream().sorted(Comparator.comparing(o -> o.getJavaClass().getCanonicalName())).collect(Collectors.toList());
        for (DataObject object : orderedSchemaObjects) {
            String basicShortName = object.getJavaClass().getSimpleName();
            String shortName = basicShortName;
            if (!referenceNames.contains(shortName)) {
                object.setSchemaReferenceName(shortName);
                referenceNames.add(shortName);
                this.classToSchemaObject.put(object.getJavaClass(), object);
                continue;
            }
            int i = 1;
            while (referenceNames.contains(shortName)) {
                shortName = basicShortName + "_" + i;
                ++i;
            }
            object.setSchemaReferenceName(shortName);
            referenceNames.add(shortName);
            this.classToSchemaObject.put(object.getJavaClass(), object);
        }
    }
}

