/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassLoaderUtils {
    private static final Map<String, Class> map = new ConcurrentHashMap<String, Class>();

    public static Class getByName(String canonicalName) throws ClassNotFoundException {
        Class clazz = map.get(canonicalName);
        if (clazz == null) {
            map.put(canonicalName, Class.forName(canonicalName, true, ReflectionsUtils.getProjectClassLoader()));
            clazz = map.get(canonicalName);
        }
        return clazz;
    }

    public static Class getByNameRuntimeEx(String canonicalName) {
        try {
            return ClassLoaderUtils.getByName(canonicalName);
        }
        catch (ClassNotFoundException e) {
            throw new MojoRuntimeException(canonicalName + " cannot be loaded. Please check if the correct dependencies are in your project classpath.", e);
        }
    }
}

