/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class YamlParserUtils {
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES));

    public static JsonNode readResourceFile(String path) {
        JsonNode jsonNode;
        block8: {
            InputStream in = YamlParserUtils.class.getResourceAsStream(path);
            try {
                jsonNode = mapper.readTree(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Impossible to read yml resource from path " + path, e);
                }
            }
            in.close();
        }
        return jsonNode;
    }

    public static JsonNode readFile(String path) {
        JsonNode jsonNode;
        block8: {
            InputStream in = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            try {
                jsonNode = mapper.readTree(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Impossible to read yml file from path " + path, e);
                }
            }
            in.close();
        }
        return jsonNode;
    }
}

