/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.javadoc;

import com.github.javaparser.javadoc.Javadoc;
import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.javadoc.JavadocMap;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ClassDocumentation {
    private final String completeName;
    private final String simpleName;
    private JavadocWrapper javadocWrapper;
    private Map<String, JavadocWrapper> fieldsJavadoc;
    private Map<String, JavadocWrapper> methodsJavadoc;
    private boolean inheritanceEnhancementIsDone = false;
    private Class<?> javaClass;

    public ClassDocumentation(String completeName, String simpleName) {
        this.completeName = completeName;
        this.simpleName = simpleName;
    }

    public void inheritanceEnhancement(Class<?> javaClass, EnhancementType enhancementType) {
        Method[] methods;
        List<Field> fields;
        if (this.inheritanceEnhancementIsDone) {
            return;
        }
        this.inheritanceEnhancementIsDone = true;
        this.javaClass = javaClass;
        Map<String, ClassDocumentation> javadocMap = JavadocMap.INSTANCE.getJavadocMap();
        HashSet<ClassDocumentation> parentsClassDocumentation = new HashSet<ClassDocumentation>();
        if (javaClass.getSuperclass() != null && Object.class != javaClass.getSuperclass()) {
            this.listInheritance(javadocMap, parentsClassDocumentation, javaClass.getSuperclass());
        }
        for (Class<?> javaInterface : javaClass.getInterfaces()) {
            this.listInheritance(javadocMap, parentsClassDocumentation, javaInterface);
        }
        if (parentsClassDocumentation.isEmpty()) {
            return;
        }
        for (ClassDocumentation parentClass : parentsClassDocumentation) {
            if (this.javadocWrapper != null && !this.javadocWrapper.isInheritTagFound()) continue;
            JavadocWrapper parentJavadoc = parentClass.getJavadoc();
            if (parentJavadoc != null) {
                parentJavadoc.sortTags();
            }
            if (parentJavadoc == null || parentJavadoc.isInheritTagFound()) continue;
            this.javadocWrapper = parentJavadoc;
            break;
        }
        if (!(EnhancementType.FIELDS != enhancementType && EnhancementType.BOTH != enhancementType || (fields = ReflectionsUtils.getAllNonStaticFields(new ArrayList<Field>(), javaClass)).isEmpty())) {
            ArrayList<JavadocEntry> fieldEntriesToAddOrReplace = new ArrayList<JavadocEntry>();
            block2: for (Field field : fields) {
                JavadocWrapper currentJavadoc = this.getFieldsJavadoc().get(field.getName());
                if (currentJavadoc != null) {
                    currentJavadoc.sortTags();
                }
                if (currentJavadoc != null && !currentJavadoc.isInheritTagFound()) continue;
                for (ClassDocumentation parentClass : parentsClassDocumentation) {
                    JavadocWrapper parentJavadoc = parentClass.getFieldsJavadoc().get(field.getName());
                    if (parentJavadoc != null) {
                        parentJavadoc.sortTags();
                    }
                    if (parentJavadoc == null || parentJavadoc.isInheritTagFound()) continue;
                    fieldEntriesToAddOrReplace.add(new JavadocEntry(field.getName(), parentJavadoc));
                    continue block2;
                }
            }
            for (JavadocEntry entry : fieldEntriesToAddOrReplace) {
                this.getFieldsJavadoc().put(entry.name, entry.javadocWrapper);
            }
        }
        if ((EnhancementType.METHODS == enhancementType || EnhancementType.BOTH == enhancementType) && (methods = javaClass.getMethods()).length > 0) {
            ArrayList<JavadocEntry> methodEntriesToAddOrReplace = new ArrayList<JavadocEntry>();
            block5: for (Method method : methods) {
                String methodIdentifier = JavaClassAnalyser.createIdentifier(method);
                JavadocWrapper currentJavadoc = this.getMethodsJavadoc().get(methodIdentifier);
                if (currentJavadoc != null) {
                    currentJavadoc.sortTags();
                }
                if (currentJavadoc != null && !currentJavadoc.isInheritTagFound()) continue;
                for (ClassDocumentation parentClass : parentsClassDocumentation) {
                    JavadocWrapper parentJavadoc = parentClass.getMethodsJavadoc().get(methodIdentifier);
                    if (parentJavadoc != null) {
                        parentJavadoc.sortTags();
                    }
                    if (parentJavadoc == null || parentJavadoc.isInheritTagFound()) continue;
                    methodEntriesToAddOrReplace.add(new JavadocEntry(methodIdentifier, parentJavadoc));
                    continue block5;
                }
            }
            for (JavadocEntry entry : methodEntriesToAddOrReplace) {
                this.getMethodsJavadoc().put(entry.name, entry.javadocWrapper);
            }
        }
    }

    private void listInheritance(Map<String, ClassDocumentation> javadocMap, Set<ClassDocumentation> documentationSet, Class<?> classToAdd) {
        ClassDocumentation classDocumentation = javadocMap.get(classToAdd.getCanonicalName());
        if (classDocumentation != null) {
            documentationSet.add(classDocumentation);
            if (classToAdd.getSuperclass() != null && Object.class != classToAdd.getSuperclass()) {
                this.listInheritance(javadocMap, documentationSet, classToAdd.getSuperclass());
            }
            for (Class<?> javaInterface : classToAdd.getInterfaces()) {
                this.listInheritance(javadocMap, documentationSet, javaInterface);
            }
        }
    }

    public String getCompleteName() {
        return this.completeName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public JavadocWrapper getJavadoc() {
        return this.javadocWrapper;
    }

    public void setJavadoc(Javadoc javadoc) {
        this.javadocWrapper = new JavadocWrapper(javadoc);
    }

    public Map<String, JavadocWrapper> getFieldsJavadoc() {
        if (this.fieldsJavadoc == null) {
            this.fieldsJavadoc = new HashMap<String, JavadocWrapper>();
        }
        return this.fieldsJavadoc;
    }

    public Map<String, JavadocWrapper> getMethodsJavadoc() {
        if (this.methodsJavadoc == null) {
            this.methodsJavadoc = new HashMap<String, JavadocWrapper>();
        }
        return this.methodsJavadoc;
    }

    public Optional<String> getDescription() {
        if (this.javadocWrapper != null) {
            return this.javadocWrapper.getDescription();
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDocumentation that = (ClassDocumentation)o;
        return Objects.equals(this.completeName, that.completeName);
    }

    public int hashCode() {
        return Objects.hash(this.completeName);
    }

    public static enum EnhancementType {
        FIELDS,
        METHODS,
        BOTH;

    }

    private class JavadocEntry {
        protected String name;
        protected JavadocWrapper javadocWrapper;

        public JavadocEntry(String name, JavadocWrapper javadocWrapper) {
            this.name = name;
            this.javadocWrapper = javadocWrapper;
        }
    }
}

