/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.utils;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.kbuntrock.utils.OpenApiDataType;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenApiResolvedType {
    private final OpenApiDataType type;
    private final String modelName;
    private final JsonNode node;
    private boolean completeNode = true;
    private final Map<String, JsonNode> schemaSection = new LinkedHashMap<String, JsonNode>();

    public OpenApiResolvedType(OpenApiDataType type, JsonNode node, String modelName) {
        this.type = type;
        this.node = node;
        this.modelName = modelName;
        if (node != null) {
            node.fields().forEachRemaining(entry -> this.schemaSection.put((String)entry.getKey(), (JsonNode)entry.getValue()));
        }
    }

    public OpenApiDataType getType() {
        return this.type;
    }

    public Map<String, JsonNode> getSchemaSection() {
        return this.schemaSection;
    }

    public boolean isCompleteNode() {
        return this.completeNode;
    }

    public void setCompleteNode(boolean completeNode) {
        this.completeNode = completeNode;
    }

    public String getModelName() {
        return this.modelName;
    }

    public OpenApiResolvedType copy() {
        OpenApiResolvedType copy = new OpenApiResolvedType(this.type, this.node, this.modelName);
        copy.completeNode = this.completeNode;
        return copy;
    }
}

