/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.micrometer.FeignMetricName;
import feign.micrometer.FeignMetricTagResolver;
import feign.micrometer.MetricName;
import feign.micrometer.MetricTagResolver;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.Type;

public class MeteredEncoder
implements Encoder {
    private final Encoder encoder;
    private final MeterRegistry meterRegistry;
    private final MetricName metricName;
    private final MetricTagResolver metricTagResolver;

    public MeteredEncoder(Encoder encoder, MeterRegistry meterRegistry) {
        this(encoder, meterRegistry, new FeignMetricName(Encoder.class), new FeignMetricTagResolver());
    }

    public MeteredEncoder(Encoder encoder, MeterRegistry meterRegistry, MetricName metricName, MetricTagResolver metricTagResolver) {
        this.encoder = encoder;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
        this.metricTagResolver = metricTagResolver;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        this.createTimer(object, bodyType, template).record(() -> this.encoder.encode(object, bodyType, template));
        if (template.body() != null) {
            this.createSummary(object, bodyType, template).record((double)template.body().length);
        }
    }

    protected Timer createTimer(Object object, Type bodyType, RequestTemplate template) {
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), this.extraTags(object, bodyType, template));
        return this.meterRegistry.timer(this.metricName.name(), (Iterable)allTags);
    }

    protected DistributionSummary createSummary(Object object, Type bodyType, RequestTemplate template) {
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), this.extraTags(object, bodyType, template));
        return this.meterRegistry.summary(this.metricName.name("response_size"), (Iterable)allTags);
    }

    protected Tag[] extraTags(Object object, Type bodyType, RequestTemplate template) {
        return MetricTagResolver.EMPTY_TAGS_ARRAY;
    }
}

