/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.logback.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxy;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.logback.LogbackExtensionsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 :2\u00020\u0001:\u0001:B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0015\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010\u001fJ\n\u0010 \u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\rH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120-H\u0016J\b\u0010.\u001a\u00020\u0014H\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000300H\u0016J\u0014\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000300H\u0017J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00100-H\u0016J\n\u00103\u001a\u0004\u0018\u00010\u0010H\u0017J\b\u00104\u001a\u000205H\u0016J\u0013\u00106\u001a\b\u0012\u0004\u0012\u0002070\u001dH\u0016\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/github/oshai/kotlinlogging/logback/internal/LogbackLogEvent;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "fqcn", "", "logger", "Lch/qos/logback/classic/Logger;", "level", "Lio/github/oshai/kotlinlogging/Level;", "kLoggingEvent", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "<init>", "(Ljava/lang/String;Lch/qos/logback/classic/Logger;Lio/github/oshai/kotlinlogging/Level;Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;)V", "creationTime", "", "markers", "", "Lorg/slf4j/Marker;", "keyValuePairs", "Lorg/slf4j/event/KeyValuePair;", "addMarker", "", "marker", "addKeyValuePair", "kvp", "getThreadName", "getLevel", "Lch/qos/logback/classic/Level;", "getMessage", "getArgumentArray", "", "Ljava/lang/Object;", "()[Ljava/lang/Object;", "getFormattedMessage", "getLoggerName", "getLoggerContextVO", "Lch/qos/logback/classic/spi/LoggerContextVO;", "getThrowableProxy", "Lch/qos/logback/classic/spi/IThrowableProxy;", "getTimeStamp", "getInstant", "Ljava/time/Instant;", "getNanoseconds", "", "getSequenceNumber", "getKeyValuePairs", "", "prepareForDeferredProcessing", "getMDCPropertyMap", "", "getMdc", "getMarkerList", "getMarker", "hasCallerData", "", "getCallerData", "Ljava/lang/StackTraceElement;", "()[Ljava/lang/StackTraceElement;", "toString", "Companion", "kotlin-logging"})
@SourceDebugExtension(value={"SMAP\nLogbackLogEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogbackLogEvent.kt\nio/github/oshai/kotlinlogging/logback/internal/LogbackLogEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class LogbackLogEvent
implements ILoggingEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fqcn;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Level level;
    @NotNull
    private final KLoggingEventBuilder kLoggingEvent;
    private final long creationTime;
    @NotNull
    private final List<Marker> markers;
    @NotNull
    private final List<KeyValuePair> keyValuePairs;
    @NotNull
    private static final AtomicLong sequenceNumberGenerator = new AtomicLong(0L);

    public LogbackLogEvent(@NotNull String fqcn, @NotNull Logger logger, @NotNull Level level, @NotNull KLoggingEventBuilder kLoggingEvent) {
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)kLoggingEvent, (String)"kLoggingEvent");
        this.fqcn = fqcn;
        this.logger = logger;
        this.level = level;
        this.kLoggingEvent = kLoggingEvent;
        this.creationTime = System.currentTimeMillis();
        this.markers = new ArrayList();
        this.keyValuePairs = new ArrayList();
    }

    public final void addMarker(@NotNull Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.markers.add(marker);
    }

    public final void addKeyValuePair(@NotNull KeyValuePair kvp) {
        Intrinsics.checkNotNullParameter((Object)kvp, (String)"kvp");
        this.keyValuePairs.add(kvp);
    }

    @NotNull
    public String getThreadName() {
        String string = Thread.currentThread().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public ch.qos.logback.classic.Level getLevel() {
        return LogbackExtensionsKt.toLogbackLevel(this.level);
    }

    @NotNull
    public String getMessage() {
        Object object = this.kLoggingEvent.getInternalCompilerData$kotlin_logging();
        if ((object == null || (object = ((KLoggingEventBuilder.InternalCompilerData)object).getMessageTemplate()) == null) && (object = this.kLoggingEvent.getMessage()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public Object[] getArgumentArray() {
        Object[] objectArray = this.kLoggingEvent.getArguments();
        return objectArray instanceof Object[] ? objectArray : null;
    }

    @Nullable
    public String getFormattedMessage() {
        return this.kLoggingEvent.getMessage();
    }

    @NotNull
    public String getLoggerName() {
        String string = this.logger.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Nullable
    public LoggerContextVO getLoggerContextVO() {
        return this.logger.getLoggerContext().getLoggerContextRemoteView();
    }

    @Nullable
    public IThrowableProxy getThrowableProxy() {
        ThrowableProxy throwableProxy;
        Throwable throwable = this.kLoggingEvent.getCause();
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throwableProxy = new ThrowableProxy(it);
        } else {
            throwableProxy = null;
        }
        return (IThrowableProxy)throwableProxy;
    }

    public long getTimeStamp() {
        return this.creationTime;
    }

    @NotNull
    public Instant getInstant() {
        Instant instant = Instant.ofEpochMilli(this.creationTime);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        return instant;
    }

    public int getNanoseconds() {
        return 0;
    }

    public long getSequenceNumber() {
        return sequenceNumberGenerator.getAndIncrement();
    }

    @NotNull
    public List<KeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public void prepareForDeferredProcessing() {
    }

    @NotNull
    public Map<String, String> getMDCPropertyMap() {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Deprecated(message="Deprecated in ILoggingEvent")
    @NotNull
    public Map<String, String> getMdc() {
        return this.getMDCPropertyMap();
    }

    @NotNull
    public List<Marker> getMarkerList() {
        return this.markers;
    }

    @Deprecated(message="Deprecated in ILoggingEvent")
    @Nullable
    public Marker getMarker() {
        return (Marker)CollectionsKt.firstOrNull(this.markers);
    }

    public boolean hasCallerData() {
        KLoggingEventBuilder.InternalCompilerData internalCompilerData = this.kLoggingEvent.getInternalCompilerData$kotlin_logging();
        return (internalCompilerData != null ? internalCompilerData.getFileName() : null) != null ? true : !(this.getCallerData().length == 0);
    }

    @NotNull
    public StackTraceElement[] getCallerData() {
        KLoggingEventBuilder.InternalCompilerData internalCompilerData = this.kLoggingEvent.getInternalCompilerData$kotlin_logging();
        if ((internalCompilerData != null ? internalCompilerData.getFileName() : null) != null) {
            Object object;
            Object object2;
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[1];
            Object object3 = this.kLoggingEvent.getInternalCompilerData$kotlin_logging();
            if (object3 == null || (object3 = ((KLoggingEventBuilder.InternalCompilerData)object3).getClassName()) == null) {
                object3 = "";
            }
            if ((object2 = this.kLoggingEvent.getInternalCompilerData$kotlin_logging()) == null || (object2 = ((KLoggingEventBuilder.InternalCompilerData)object2).getMethodName()) == null) {
                object2 = "";
            }
            KLoggingEventBuilder.InternalCompilerData internalCompilerData2 = this.kLoggingEvent.getInternalCompilerData$kotlin_logging();
            stackTraceElementArray[0] = new StackTraceElement((String)object3, (String)object2, internalCompilerData2 != null ? internalCompilerData2.getFileName() : null, (object = this.kLoggingEvent.getInternalCompilerData$kotlin_logging()) != null && (object = ((KLoggingEventBuilder.InternalCompilerData)object).getLineNumber()) != null ? (Integer)object : 0);
            return stackTraceElementArray;
        }
        StackTraceElement[] stackTraceElementArray = CallerData.extract((Throwable)new Throwable(), (String)this.fqcn, (int)8, (List)this.logger.getLoggerContext().getFrameworkPackages());
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"extract(...)");
        return stackTraceElementArray;
    }

    @NotNull
    public String toString() {
        return "LogbackLogEvent(level=" + (Object)((Object)this.level) + ", message=" + this.getMessage() + ')';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/oshai/kotlinlogging/logback/internal/LogbackLogEvent$Companion;", "", "<init>", "()V", "sequenceNumberGenerator", "Ljava/util/concurrent/atomic/AtomicLong;", "kotlin-logging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

