/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.jul.internal;

import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J3\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0\u0014\u00a2\u0006\u0002\b\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lio/github/oshai/kotlinlogging/jul/internal/JulLoggerWrapper;", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/oshai/kotlinlogging/DelegatingKLogger;", "Ljava/util/logging/Logger;", "underlyingLogger", "<init>", "(Ljava/util/logging/Logger;)V", "getUnderlyingLogger", "()Ljava/util/logging/Logger;", "name", "", "getName", "()Ljava/lang/String;", "at", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "isLoggingEnabledFor", "", "toJULLevel", "Ljava/util/logging/Level;", "kotlin-logging"})
public final class JulLoggerWrapper
implements KLogger,
DelegatingKLogger<Logger> {
    @NotNull
    private final Logger underlyingLogger;

    public JulLoggerWrapper(@NotNull Logger underlyingLogger) {
        Intrinsics.checkNotNullParameter((Object)underlyingLogger, (String)"underlyingLogger");
        this.underlyingLogger = underlyingLogger;
    }

    @Override
    @NotNull
    public Logger getUnderlyingLogger() {
        return this.underlyingLogger;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getUnderlyingLogger().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.isLoggingEnabledFor(level, null)) {
            KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
            block.invoke((Object)kLoggingEventBuilder);
            KLoggingEventBuilder $this$at_u24lambda_u240 = kLoggingEventBuilder;
            boolean bl = false;
            this.getUnderlyingLogger().log(this.toJULLevel(level), $this$at_u24lambda_u240.getMessage(), $this$at_u24lambda_u240.getCause());
        }
    }

    @Override
    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.getUnderlyingLogger().isLoggable(this.toJULLevel(level));
    }

    private final java.util.logging.Level toJULLevel(Level $this$toJULLevel) {
        java.util.logging.Level level;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toJULLevel.ordinal()]) {
            case 1: {
                java.util.logging.Level level2 = java.util.logging.Level.FINEST;
                level = level2;
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
                break;
            }
            case 2: {
                java.util.logging.Level level3 = java.util.logging.Level.FINE;
                level = level3;
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"FINE");
                break;
            }
            case 3: {
                java.util.logging.Level level4 = java.util.logging.Level.INFO;
                level = level4;
                Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"INFO");
                break;
            }
            case 4: {
                java.util.logging.Level level5 = java.util.logging.Level.WARNING;
                level = level5;
                Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"WARNING");
                break;
            }
            case 5: {
                java.util.logging.Level level6 = java.util.logging.Level.SEVERE;
                level = level6;
                Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"SEVERE");
                break;
            }
            case 6: {
                java.util.logging.Level level7 = java.util.logging.Level.OFF;
                level = level7;
                Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"OFF");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        java.util.logging.Level julLevel = level;
        return julLevel;
    }

    @Override
    public boolean isTraceEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isTraceEnabled(this, marker);
    }

    @Override
    public boolean isDebugEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isDebugEnabled(this, marker);
    }

    @Override
    public boolean isInfoEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isInfoEnabled(this, marker);
    }

    @Override
    public boolean isWarnEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isWarnEnabled(this, marker);
    }

    @Override
    public boolean isErrorEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isErrorEnabled(this, marker);
    }

    @Override
    public boolean isLoggingOff(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isLoggingOff(this, marker);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace(this, message);
    }

    @Override
    public void trace(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace((KLogger)this, throwable, message);
    }

    @Override
    public void trace(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, message);
    }

    @Override
    public void trace(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace(this, marker, throwable, message);
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug(this, message);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug((KLogger)this, throwable, message);
    }

    @Override
    public void debug(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, message);
    }

    @Override
    public void debug(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug(this, marker, throwable, message);
    }

    @Override
    public void info(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info(this, message);
    }

    @Override
    public void info(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info((KLogger)this, throwable, message);
    }

    @Override
    public void info(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info((KLogger)this, marker, message);
    }

    @Override
    public void info(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info(this, marker, throwable, message);
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn(this, message);
    }

    @Override
    public void warn(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn((KLogger)this, throwable, message);
    }

    @Override
    public void warn(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, message);
    }

    @Override
    public void warn(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn(this, marker, throwable, message);
    }

    @Override
    public void error(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error(this, message);
    }

    @Override
    public void error(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error((KLogger)this, throwable, message);
    }

    @Override
    public void error(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error((KLogger)this, marker, message);
    }

    @Override
    public void error(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error(this, marker, throwable, message);
    }

    @Override
    public void atTrace(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atTrace(this, marker, block);
    }

    @Override
    public void atTrace(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atTrace(this, block);
    }

    @Override
    public void atDebug(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atDebug(this, marker, block);
    }

    @Override
    public void atDebug(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atDebug(this, block);
    }

    @Override
    public void atInfo(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atInfo(this, marker, block);
    }

    @Override
    public void atInfo(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atInfo(this, block);
    }

    @Override
    public void atWarn(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atWarn(this, marker, block);
    }

    @Override
    public void atWarn(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atWarn(this, block);
    }

    @Override
    public void atError(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atError(this, marker, block);
    }

    @Override
    public void atError(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atError(this, block);
    }

    @Override
    public void entry(Object ... arguments) {
        KLogger.DefaultImpls.entry(this, arguments);
    }

    @Override
    public void exit() {
        KLogger.DefaultImpls.exit(this);
    }

    @Override
    public <T> T exit(T result) {
        return KLogger.DefaultImpls.exit(this, result);
    }

    @Override
    @NotNull
    public <T extends Throwable> T throwing(@NotNull T throwable) {
        return KLogger.DefaultImpls.throwing(this, throwable);
    }

    @Override
    public <T extends Throwable> void catching(@NotNull T throwable) {
        KLogger.DefaultImpls.catching(this, throwable);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.OFF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

