/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.slf4j.internal;

import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import io.github.oshai.kotlinlogging.slf4j.Slf4jExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004\u00a8\u0006\u000e"}, d2={"Lio/github/oshai/kotlinlogging/slf4j/internal/Slf4jLogger;", "T", "Lorg/slf4j/Logger;", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/oshai/kotlinlogging/DelegatingKLogger;", "<init>", "()V", "isLoggingEnabledFor", "", "underlyingLogger", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "kotlin-logging"})
public abstract class Slf4jLogger<T extends Logger>
implements KLogger,
DelegatingKLogger<T> {
    protected final boolean isLoggingEnabledFor(@NotNull Logger underlyingLogger, @NotNull Level level, @Nullable Marker marker) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)underlyingLogger, (String)"underlyingLogger");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                Marker marker2 = marker;
                bl = underlyingLogger.isTraceEnabled((org.slf4j.Marker)(marker2 != null ? Slf4jExtensionsKt.toSlf4j(marker2) : null));
                break;
            }
            case 2: {
                Marker marker3 = marker;
                bl = underlyingLogger.isDebugEnabled((org.slf4j.Marker)(marker3 != null ? Slf4jExtensionsKt.toSlf4j(marker3) : null));
                break;
            }
            case 3: {
                Marker marker4 = marker;
                bl = underlyingLogger.isInfoEnabled((org.slf4j.Marker)(marker4 != null ? Slf4jExtensionsKt.toSlf4j(marker4) : null));
                break;
            }
            case 4: {
                Marker marker5 = marker;
                bl = underlyingLogger.isWarnEnabled((org.slf4j.Marker)(marker5 != null ? Slf4jExtensionsKt.toSlf4j(marker5) : null));
                break;
            }
            case 5: {
                Marker marker6 = marker;
                bl = underlyingLogger.isErrorEnabled((org.slf4j.Marker)(marker6 != null ? Slf4jExtensionsKt.toSlf4j(marker6) : null));
                break;
            }
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    public boolean isTraceEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isTraceEnabled(this, marker);
    }

    @Override
    public boolean isDebugEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isDebugEnabled(this, marker);
    }

    @Override
    public boolean isInfoEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isInfoEnabled(this, marker);
    }

    @Override
    public boolean isWarnEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isWarnEnabled(this, marker);
    }

    @Override
    public boolean isErrorEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isErrorEnabled(this, marker);
    }

    @Override
    public boolean isLoggingOff(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isLoggingOff(this, marker);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace(this, message);
    }

    @Override
    public void trace(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace((KLogger)this, throwable, message);
    }

    @Override
    public void trace(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, message);
    }

    @Override
    public void trace(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.trace(this, marker, throwable, message);
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug(this, message);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug((KLogger)this, throwable, message);
    }

    @Override
    public void debug(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, message);
    }

    @Override
    public void debug(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.debug(this, marker, throwable, message);
    }

    @Override
    public void info(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info(this, message);
    }

    @Override
    public void info(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info((KLogger)this, throwable, message);
    }

    @Override
    public void info(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info((KLogger)this, marker, message);
    }

    @Override
    public void info(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.info(this, marker, throwable, message);
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn(this, message);
    }

    @Override
    public void warn(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn((KLogger)this, throwable, message);
    }

    @Override
    public void warn(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, message);
    }

    @Override
    public void warn(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.warn(this, marker, throwable, message);
    }

    @Override
    public void error(@NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error(this, message);
    }

    @Override
    public void error(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error((KLogger)this, throwable, message);
    }

    @Override
    public void error(@Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error((KLogger)this, marker, message);
    }

    @Override
    public void error(@Nullable Marker marker, @Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        KLogger.DefaultImpls.error(this, marker, throwable, message);
    }

    @Override
    public void atTrace(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atTrace(this, marker, block);
    }

    @Override
    public void atTrace(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atTrace(this, block);
    }

    @Override
    public void atDebug(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atDebug(this, marker, block);
    }

    @Override
    public void atDebug(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atDebug(this, block);
    }

    @Override
    public void atInfo(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atInfo(this, marker, block);
    }

    @Override
    public void atInfo(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atInfo(this, block);
    }

    @Override
    public void atWarn(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atWarn(this, marker, block);
    }

    @Override
    public void atWarn(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atWarn(this, block);
    }

    @Override
    public void atError(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atError(this, marker, block);
    }

    @Override
    public void atError(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        KLogger.DefaultImpls.atError(this, block);
    }

    @Override
    public void entry(Object ... arguments) {
        KLogger.DefaultImpls.entry(this, arguments);
    }

    @Override
    public void exit() {
        KLogger.DefaultImpls.exit(this);
    }

    @Override
    public <T> T exit(T result) {
        return KLogger.DefaultImpls.exit(this, result);
    }

    @Override
    @NotNull
    public <T extends Throwable> T throwing(@NotNull T throwable) {
        return KLogger.DefaultImpls.throwing(this, throwable);
    }

    @Override
    public <T extends Throwable> void catching(@NotNull T throwable) {
        KLogger.DefaultImpls.catching(this, throwable);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.OFF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

