/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.internal.InMemoryBulkheadRegistry;
import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.vavr.collection.Seq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface BulkheadRegistry
extends Registry<Bulkhead, BulkheadConfig> {
    public static BulkheadRegistry of(BulkheadConfig bulkheadConfig) {
        return new InMemoryBulkheadRegistry(bulkheadConfig);
    }

    public static BulkheadRegistry of(BulkheadConfig bulkheadConfig, io.vavr.collection.Map<String, String> tags) {
        return new InMemoryBulkheadRegistry(bulkheadConfig, tags);
    }

    public static BulkheadRegistry of(BulkheadConfig bulkheadConfig, RegistryEventConsumer<Bulkhead> registryEventConsumer) {
        return new InMemoryBulkheadRegistry(bulkheadConfig, registryEventConsumer);
    }

    public static BulkheadRegistry of(BulkheadConfig bulkheadConfig, List<RegistryEventConsumer<Bulkhead>> registryEventConsumers) {
        return new InMemoryBulkheadRegistry(bulkheadConfig, registryEventConsumers);
    }

    public static BulkheadRegistry of(Map<String, BulkheadConfig> configs) {
        return new InMemoryBulkheadRegistry(configs);
    }

    public static BulkheadRegistry of(Map<String, BulkheadConfig> configs, io.vavr.collection.Map<String, String> tags) {
        return new InMemoryBulkheadRegistry(configs, tags);
    }

    public static BulkheadRegistry of(Map<String, BulkheadConfig> configs, RegistryEventConsumer<Bulkhead> registryEventConsumer) {
        return new InMemoryBulkheadRegistry(configs, registryEventConsumer);
    }

    public static BulkheadRegistry of(Map<String, BulkheadConfig> configs, RegistryEventConsumer<Bulkhead> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        return new InMemoryBulkheadRegistry(configs, registryEventConsumer, tags);
    }

    public static BulkheadRegistry of(Map<String, BulkheadConfig> configs, List<RegistryEventConsumer<Bulkhead>> registryEventConsumers) {
        return new InMemoryBulkheadRegistry(configs, registryEventConsumers);
    }

    public static BulkheadRegistry ofDefaults() {
        return new InMemoryBulkheadRegistry(BulkheadConfig.ofDefaults());
    }

    public Seq<Bulkhead> getAllBulkheads();

    public Bulkhead bulkhead(String var1);

    public Bulkhead bulkhead(String var1, io.vavr.collection.Map<String, String> var2);

    public Bulkhead bulkhead(String var1, BulkheadConfig var2);

    public Bulkhead bulkhead(String var1, BulkheadConfig var2, io.vavr.collection.Map<String, String> var3);

    public Bulkhead bulkhead(String var1, Supplier<BulkheadConfig> var2);

    public Bulkhead bulkhead(String var1, Supplier<BulkheadConfig> var2, io.vavr.collection.Map<String, String> var3);

    public Bulkhead bulkhead(String var1, String var2);

    public Bulkhead bulkhead(String var1, String var2, io.vavr.collection.Map<String, String> var3);

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_CONFIG = "default";
        private RegistryStore registryStore;
        private Map<String, BulkheadConfig> bulkheadConfigsMap = new HashMap<String, BulkheadConfig>();
        private List<RegistryEventConsumer<Bulkhead>> registryEventConsumers = new ArrayList<RegistryEventConsumer<Bulkhead>>();
        private io.vavr.collection.Map<String, String> tags;

        public Builder withRegistryStore(RegistryStore registryStore) {
            this.registryStore = registryStore;
            return this;
        }

        public Builder withBulkheadConfig(BulkheadConfig bulkheadConfig) {
            this.bulkheadConfigsMap.put(DEFAULT_CONFIG, bulkheadConfig);
            return this;
        }

        public Builder addBulkheadConfig(String configName, BulkheadConfig configuration) {
            if (configName.equals(DEFAULT_CONFIG)) {
                throw new IllegalArgumentException("You cannot add another configuration with name 'default' as it is preserved for default configuration");
            }
            this.bulkheadConfigsMap.put(configName, configuration);
            return this;
        }

        public Builder addRegistryEventConsumer(RegistryEventConsumer<Bulkhead> registryEventConsumer) {
            this.registryEventConsumers.add(registryEventConsumer);
            return this;
        }

        public Builder withTags(io.vavr.collection.Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public BulkheadRegistry build() {
            return new InMemoryBulkheadRegistry(this.bulkheadConfigsMap, this.registryEventConsumers, this.tags, (RegistryStore<Bulkhead>)this.registryStore);
        }
    }
}

