/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.functions;

import io.github.resilience4j.core.functions.CheckedFunction;
import java.util.Objects;
import java.util.function.Supplier;

@FunctionalInterface
public interface CheckedSupplier<T> {
    public T get() throws Throwable;

    default public <V> CheckedSupplier<V> andThen(CheckedFunction<? super T, ? extends V> after) {
        Objects.requireNonNull(after, "after is null");
        return () -> after.apply((T)this.get());
    }

    default public Supplier<T> unchecked() {
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable t) {
                return CheckedSupplier.sneakyThrow(t);
            }
        };
    }

    public static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        throw t;
    }
}

