/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.circuitbreaker.monitoring.endpoint;

import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTOFactory;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="circuitbreakerevents")
public class CircuitBreakerEventsEndpoint {
    private final EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry;

    public CircuitBreakerEventsEndpoint(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @ReadOperation
    public CircuitBreakerEventsEndpointResponse getAllCircuitBreakerEvents() {
        return new CircuitBreakerEventsEndpointResponse(this.eventConsumerRegistry.getAllEventConsumer().stream().flatMap(CircularEventConsumer::getBufferedEventsStream).sorted(Comparator.comparing(CircuitBreakerEvent::getCreationTime)).map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public CircuitBreakerEventsEndpointResponse getEventsFilteredByCircuitBreakerName(@Selector String name) {
        return new CircuitBreakerEventsEndpointResponse(this.getCircuitBreakerEvents(name).stream().map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public CircuitBreakerEventsEndpointResponse getEventsFilteredByCircuitBreakerNameAndEventType(@Selector String name, @Selector String eventType) {
        return new CircuitBreakerEventsEndpointResponse(this.getCircuitBreakerEvents(name).stream().filter(event -> event.getEventType() == CircuitBreakerEvent.Type.valueOf((String)eventType.toUpperCase())).map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).collect(Collectors.toList()));
    }

    private List<CircuitBreakerEvent> getCircuitBreakerEvents(String circuitBreakerName) {
        CircularEventConsumer eventConsumer = this.eventConsumerRegistry.getEventConsumer(circuitBreakerName);
        if (eventConsumer != null) {
            return eventConsumer.getBufferedEventsStream().filter(event -> event.getCircuitBreakerName().equals(circuitBreakerName)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

