/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.bindings.amqp;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;

public class AMQPOperationBinding
extends OperationBinding {
    @PositiveOrZero
    @JsonProperty(value="expiration")
    private Integer expiration;
    @JsonProperty(value="userId")
    private String userId;
    @JsonProperty(value="cc")
    private List<String> cc;
    @JsonProperty(value="priority")
    private Integer priority;
    @Min(value=1L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)")
    @Max(value=2L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)")
    @JsonProperty(value="deliveryMode")
    private @Min(value=1L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)") @Max(value=2L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)") Integer deliveryMode;
    @JsonProperty(value="mandatory")
    private Boolean mandatory;
    @JsonProperty(value="bcc")
    private List<String> bcc;
    @JsonProperty(value="timestamp")
    private Boolean timestamp;
    @JsonProperty(value="ack")
    private Boolean ack;
    @JsonProperty(value="bindingVersion")
    private String bindingVersion;

    private static Integer $default$expiration() {
        return 0;
    }

    private static String $default$bindingVersion() {
        return "0.3.0";
    }

    public static AMQPOperationBindingBuilder builder() {
        return new AMQPOperationBindingBuilder();
    }

    public Integer getExpiration() {
        return this.expiration;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public Boolean getTimestamp() {
        return this.timestamp;
    }

    public Boolean getAck() {
        return this.ack;
    }

    public String getBindingVersion() {
        return this.bindingVersion;
    }

    @JsonProperty(value="expiration")
    public void setExpiration(Integer expiration) {
        this.expiration = expiration;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="cc")
    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    @JsonProperty(value="priority")
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @JsonProperty(value="deliveryMode")
    public void setDeliveryMode(Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    @JsonProperty(value="mandatory")
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    @JsonProperty(value="bcc")
    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Boolean timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="ack")
    public void setAck(Boolean ack) {
        this.ack = ack;
    }

    @JsonProperty(value="bindingVersion")
    public void setBindingVersion(String bindingVersion) {
        this.bindingVersion = bindingVersion;
    }

    @Override
    public String toString() {
        return "AMQPOperationBinding(expiration=" + this.getExpiration() + ", userId=" + this.getUserId() + ", cc=" + this.getCc() + ", priority=" + this.getPriority() + ", deliveryMode=" + this.getDeliveryMode() + ", mandatory=" + this.getMandatory() + ", bcc=" + this.getBcc() + ", timestamp=" + this.getTimestamp() + ", ack=" + this.getAck() + ", bindingVersion=" + this.getBindingVersion() + ")";
    }

    public AMQPOperationBinding() {
        this.expiration = AMQPOperationBinding.$default$expiration();
        this.bindingVersion = AMQPOperationBinding.$default$bindingVersion();
    }

    public AMQPOperationBinding(Integer expiration, String userId, List<String> cc, Integer priority, Integer deliveryMode, Boolean mandatory, List<String> bcc, Boolean timestamp, Boolean ack, String bindingVersion) {
        this.expiration = expiration;
        this.userId = userId;
        this.cc = cc;
        this.priority = priority;
        this.deliveryMode = deliveryMode;
        this.mandatory = mandatory;
        this.bcc = bcc;
        this.timestamp = timestamp;
        this.ack = ack;
        this.bindingVersion = bindingVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AMQPOperationBinding)) {
            return false;
        }
        AMQPOperationBinding other = (AMQPOperationBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$expiration = this.getExpiration();
        Integer other$expiration = other.getExpiration();
        if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Integer this$deliveryMode = this.getDeliveryMode();
        Integer other$deliveryMode = other.getDeliveryMode();
        if (this$deliveryMode == null ? other$deliveryMode != null : !((Object)this$deliveryMode).equals(other$deliveryMode)) {
            return false;
        }
        Boolean this$mandatory = this.getMandatory();
        Boolean other$mandatory = other.getMandatory();
        if (this$mandatory == null ? other$mandatory != null : !((Object)this$mandatory).equals(other$mandatory)) {
            return false;
        }
        Boolean this$timestamp = this.getTimestamp();
        Boolean other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Boolean this$ack = this.getAck();
        Boolean other$ack = other.getAck();
        if (this$ack == null ? other$ack != null : !((Object)this$ack).equals(other$ack)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        List<String> this$cc = this.getCc();
        List<String> other$cc = other.getCc();
        if (this$cc == null ? other$cc != null : !((Object)this$cc).equals(other$cc)) {
            return false;
        }
        List<String> this$bcc = this.getBcc();
        List<String> other$bcc = other.getBcc();
        if (this$bcc == null ? other$bcc != null : !((Object)this$bcc).equals(other$bcc)) {
            return false;
        }
        String this$bindingVersion = this.getBindingVersion();
        String other$bindingVersion = other.getBindingVersion();
        return !(this$bindingVersion == null ? other$bindingVersion != null : !this$bindingVersion.equals(other$bindingVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AMQPOperationBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Integer $deliveryMode = this.getDeliveryMode();
        result = result * 59 + ($deliveryMode == null ? 43 : ((Object)$deliveryMode).hashCode());
        Boolean $mandatory = this.getMandatory();
        result = result * 59 + ($mandatory == null ? 43 : ((Object)$mandatory).hashCode());
        Boolean $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Boolean $ack = this.getAck();
        result = result * 59 + ($ack == null ? 43 : ((Object)$ack).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        List<String> $cc = this.getCc();
        result = result * 59 + ($cc == null ? 43 : ((Object)$cc).hashCode());
        List<String> $bcc = this.getBcc();
        result = result * 59 + ($bcc == null ? 43 : ((Object)$bcc).hashCode());
        String $bindingVersion = this.getBindingVersion();
        result = result * 59 + ($bindingVersion == null ? 43 : $bindingVersion.hashCode());
        return result;
    }

    public static class AMQPOperationBindingBuilder {
        private boolean expiration$set;
        private Integer expiration$value;
        private String userId;
        private List<String> cc;
        private Integer priority;
        private Integer deliveryMode;
        private Boolean mandatory;
        private List<String> bcc;
        private Boolean timestamp;
        private Boolean ack;
        private boolean bindingVersion$set;
        private String bindingVersion$value;

        AMQPOperationBindingBuilder() {
        }

        @JsonProperty(value="expiration")
        public AMQPOperationBindingBuilder expiration(Integer expiration) {
            this.expiration$value = expiration;
            this.expiration$set = true;
            return this;
        }

        @JsonProperty(value="userId")
        public AMQPOperationBindingBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="cc")
        public AMQPOperationBindingBuilder cc(List<String> cc) {
            this.cc = cc;
            return this;
        }

        @JsonProperty(value="priority")
        public AMQPOperationBindingBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @JsonProperty(value="deliveryMode")
        public AMQPOperationBindingBuilder deliveryMode(Integer deliveryMode) {
            this.deliveryMode = deliveryMode;
            return this;
        }

        @JsonProperty(value="mandatory")
        public AMQPOperationBindingBuilder mandatory(Boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        @JsonProperty(value="bcc")
        public AMQPOperationBindingBuilder bcc(List<String> bcc) {
            this.bcc = bcc;
            return this;
        }

        @JsonProperty(value="timestamp")
        public AMQPOperationBindingBuilder timestamp(Boolean timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="ack")
        public AMQPOperationBindingBuilder ack(Boolean ack) {
            this.ack = ack;
            return this;
        }

        @JsonProperty(value="bindingVersion")
        public AMQPOperationBindingBuilder bindingVersion(String bindingVersion) {
            this.bindingVersion$value = bindingVersion;
            this.bindingVersion$set = true;
            return this;
        }

        public AMQPOperationBinding build() {
            Integer expiration$value = this.expiration$value;
            if (!this.expiration$set) {
                expiration$value = AMQPOperationBinding.$default$expiration();
            }
            String bindingVersion$value = this.bindingVersion$value;
            if (!this.bindingVersion$set) {
                bindingVersion$value = AMQPOperationBinding.$default$bindingVersion();
            }
            return new AMQPOperationBinding(expiration$value, this.userId, this.cc, this.priority, this.deliveryMode, this.mandatory, this.bcc, this.timestamp, this.ack, bindingVersion$value);
        }

        public String toString() {
            return "AMQPOperationBinding.AMQPOperationBindingBuilder(expiration$value=" + this.expiration$value + ", userId=" + this.userId + ", cc=" + this.cc + ", priority=" + this.priority + ", deliveryMode=" + this.deliveryMode + ", mandatory=" + this.mandatory + ", bcc=" + this.bcc + ", timestamp=" + this.timestamp + ", ack=" + this.ack + ", bindingVersion$value=" + this.bindingVersion$value + ")";
        }
    }
}

