/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.model.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.springwolf.asyncapi.v3.bindings.ServerBinding;
import io.github.springwolf.asyncapi.v3.model.ExtendableObject;
import io.github.springwolf.asyncapi.v3.model.ExternalDocumentation;
import io.github.springwolf.asyncapi.v3.model.Reference;
import io.github.springwolf.asyncapi.v3.model.Tag;
import io.github.springwolf.asyncapi.v3.model.security_scheme.SecurityScheme;
import io.github.springwolf.asyncapi.v3.model.server.ServerVariable;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

public class Server
extends ExtendableObject
implements Reference {
    @NotNull
    @JsonProperty(value="host")
    private String host;
    @NotNull
    @JsonProperty(value="protocol")
    private String protocol;
    @JsonProperty(value="protocolVersion")
    private String protocolVersion;
    @JsonProperty(value="pathname")
    private String pathname;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="summary")
    private String summary;
    @JsonProperty(value="variables")
    private Map<String, ServerVariable> variables;
    @JsonProperty(value="security")
    private List<SecurityScheme> security;
    @JsonProperty(value="tags")
    private List<Tag> tags;
    @JsonProperty(value="externalDocs")
    private ExternalDocumentation externalDocs;
    @JsonProperty(value="bindings")
    private Map<String, ServerBinding> bindings;
    @JsonIgnore
    private String ref;

    @Override
    public String getRef() {
        return this.ref;
    }

    public static ServerBuilder builder() {
        return new ServerBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getPathname() {
        return this.pathname;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public Map<String, ServerVariable> getVariables() {
        return this.variables;
    }

    public List<SecurityScheme> getSecurity() {
        return this.security;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Map<String, ServerBinding> getBindings() {
        return this.bindings;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty(value="protocol")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty(value="protocolVersion")
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @JsonProperty(value="pathname")
    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @JsonProperty(value="variables")
    public void setVariables(Map<String, ServerVariable> variables) {
        this.variables = variables;
    }

    @JsonProperty(value="security")
    public void setSecurity(List<SecurityScheme> security) {
        this.security = security;
    }

    @JsonProperty(value="tags")
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="externalDocs")
    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    @JsonProperty(value="bindings")
    public void setBindings(Map<String, ServerBinding> bindings) {
        this.bindings = bindings;
    }

    @JsonIgnore
    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public String toString() {
        return "Server(host=" + this.getHost() + ", protocol=" + this.getProtocol() + ", protocolVersion=" + this.getProtocolVersion() + ", pathname=" + this.getPathname() + ", description=" + this.getDescription() + ", title=" + this.getTitle() + ", summary=" + this.getSummary() + ", variables=" + this.getVariables() + ", security=" + this.getSecurity() + ", tags=" + this.getTags() + ", externalDocs=" + this.getExternalDocs() + ", bindings=" + this.getBindings() + ", ref=" + this.getRef() + ")";
    }

    public Server() {
    }

    public Server(String host, String protocol, String protocolVersion, String pathname, String description, String title, String summary, Map<String, ServerVariable> variables, List<SecurityScheme> security, List<Tag> tags, ExternalDocumentation externalDocs, Map<String, ServerBinding> bindings, String ref) {
        this.host = host;
        this.protocol = protocol;
        this.protocolVersion = protocolVersion;
        this.pathname = pathname;
        this.description = description;
        this.title = title;
        this.summary = summary;
        this.variables = variables;
        this.security = security;
        this.tags = tags;
        this.externalDocs = externalDocs;
        this.bindings = bindings;
        this.ref = ref;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$protocolVersion = this.getProtocolVersion();
        String other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        String this$pathname = this.getPathname();
        String other$pathname = other.getPathname();
        if (this$pathname == null ? other$pathname != null : !this$pathname.equals(other$pathname)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        Map<String, ServerVariable> this$variables = this.getVariables();
        Map<String, ServerVariable> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        List<SecurityScheme> this$security = this.getSecurity();
        List<SecurityScheme> other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !((Object)this$security).equals(other$security)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        ExternalDocumentation this$externalDocs = this.getExternalDocs();
        ExternalDocumentation other$externalDocs = other.getExternalDocs();
        if (this$externalDocs == null ? other$externalDocs != null : !((Object)this$externalDocs).equals(other$externalDocs)) {
            return false;
        }
        Map<String, ServerBinding> this$bindings = this.getBindings();
        Map<String, ServerBinding> other$bindings = other.getBindings();
        if (this$bindings == null ? other$bindings != null : !((Object)this$bindings).equals(other$bindings)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        return !(this$ref == null ? other$ref != null : !this$ref.equals(other$ref));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        String $pathname = this.getPathname();
        result = result * 59 + ($pathname == null ? 43 : $pathname.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        Map<String, ServerVariable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        List<SecurityScheme> $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        ExternalDocumentation $externalDocs = this.getExternalDocs();
        result = result * 59 + ($externalDocs == null ? 43 : ((Object)$externalDocs).hashCode());
        Map<String, ServerBinding> $bindings = this.getBindings();
        result = result * 59 + ($bindings == null ? 43 : ((Object)$bindings).hashCode());
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        return result;
    }

    public static class ServerBuilder {
        private String host;
        private String protocol;
        private String protocolVersion;
        private String pathname;
        private String description;
        private String title;
        private String summary;
        private Map<String, ServerVariable> variables;
        private List<SecurityScheme> security;
        private List<Tag> tags;
        private ExternalDocumentation externalDocs;
        private Map<String, ServerBinding> bindings;
        private String ref;

        ServerBuilder() {
        }

        @JsonProperty(value="host")
        public ServerBuilder host(String host) {
            this.host = host;
            return this;
        }

        @JsonProperty(value="protocol")
        public ServerBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @JsonProperty(value="protocolVersion")
        public ServerBuilder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @JsonProperty(value="pathname")
        public ServerBuilder pathname(String pathname) {
            this.pathname = pathname;
            return this;
        }

        @JsonProperty(value="description")
        public ServerBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="title")
        public ServerBuilder title(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="summary")
        public ServerBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        @JsonProperty(value="variables")
        public ServerBuilder variables(Map<String, ServerVariable> variables) {
            this.variables = variables;
            return this;
        }

        @JsonProperty(value="security")
        public ServerBuilder security(List<SecurityScheme> security) {
            this.security = security;
            return this;
        }

        @JsonProperty(value="tags")
        public ServerBuilder tags(List<Tag> tags) {
            this.tags = tags;
            return this;
        }

        @JsonProperty(value="externalDocs")
        public ServerBuilder externalDocs(ExternalDocumentation externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        @JsonProperty(value="bindings")
        public ServerBuilder bindings(Map<String, ServerBinding> bindings) {
            this.bindings = bindings;
            return this;
        }

        @JsonIgnore
        public ServerBuilder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public Server build() {
            return new Server(this.host, this.protocol, this.protocolVersion, this.pathname, this.description, this.title, this.summary, this.variables, this.security, this.tags, this.externalDocs, this.bindings, this.ref);
        }

        public String toString() {
            return "Server.ServerBuilder(host=" + this.host + ", protocol=" + this.protocol + ", protocolVersion=" + this.protocolVersion + ", pathname=" + this.pathname + ", description=" + this.description + ", title=" + this.title + ", summary=" + this.summary + ", variables=" + this.variables + ", security=" + this.security + ", tags=" + this.tags + ", externalDocs=" + this.externalDocs + ", bindings=" + this.bindings + ", ref=" + this.ref + ")";
        }
    }
}

