/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi;

import io.github.springwolf.asyncapi.v3.model.AsyncAPI;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.components.Components;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.core.asyncapi.AsyncApiCustomizer;
import io.github.springwolf.core.asyncapi.AsyncApiService;
import io.github.springwolf.core.asyncapi.channels.ChannelsService;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.operations.OperationsService;
import io.github.springwolf.core.configuration.docket.AsyncApiDocket;
import io.github.springwolf.core.configuration.docket.AsyncApiDocketService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncApiService
implements AsyncApiService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncApiService.class);
    private final AsyncApiDocketService asyncApiDocketService;
    private final ChannelsService channelsService;
    private final OperationsService operationsService;
    private final ComponentsService componentsService;
    private final List<AsyncApiCustomizer> customizers;
    private volatile AsyncAPIResult asyncAPIResult = null;

    @Override
    public AsyncAPI getAsyncAPI() {
        if (this.isNotInitialized()) {
            this.initAsyncAPI();
        }
        if (this.asyncAPIResult.asyncAPI != null) {
            return this.asyncAPIResult.asyncAPI;
        }
        throw new RuntimeException("Error occured during creation of AsyncAPI", this.asyncAPIResult.exception);
    }

    protected synchronized void initAsyncAPI() {
        if (this.asyncAPIResult != null) {
            return;
        }
        try {
            log.debug("Building AsyncAPI document");
            AsyncApiDocket docket = this.asyncApiDocketService.getAsyncApiDocket();
            Map<String, ChannelObject> channels = this.channelsService.findChannels();
            Map<String, Operation> operations = this.operationsService.findOperations();
            Components components = Components.builder().schemas(this.componentsService.getSchemas()).messages(this.componentsService.getMessages()).build();
            AsyncAPI asyncAPI = AsyncAPI.builder().info(docket.getInfo()).id(docket.getId()).defaultContentType(docket.getDefaultContentType()).servers(docket.getServers()).channels(channels).operations(operations).components(components).build();
            for (AsyncApiCustomizer customizer : this.customizers) {
                log.debug("Starting customizer %s".formatted(customizer.getClass().getName()));
                customizer.customize(asyncAPI);
            }
            this.asyncAPIResult = new AsyncAPIResult(asyncAPI, null);
            log.debug("AsyncAPI document was built");
        }
        catch (Throwable t) {
            log.debug("Failed to build AsyncAPI document", t);
            this.asyncAPIResult = new AsyncAPIResult(null, t);
        }
    }

    public boolean isNotInitialized() {
        return this.asyncAPIResult == null;
    }

    public DefaultAsyncApiService(AsyncApiDocketService asyncApiDocketService, ChannelsService channelsService, OperationsService operationsService, ComponentsService componentsService, List<AsyncApiCustomizer> customizers) {
        this.asyncApiDocketService = asyncApiDocketService;
        this.channelsService = channelsService;
        this.operationsService = operationsService;
        this.componentsService = componentsService;
        this.customizers = customizers;
    }

    private record AsyncAPIResult(AsyncAPI asyncAPI, Throwable exception) {
    }
}

