/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components;

import io.github.springwolf.asyncapi.v3.model.channel.message.Message;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.annotations.AsyncApiPayload;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.components.SwaggerSchemaUtil;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeaders;
import io.github.springwolf.core.asyncapi.components.postprocessors.SchemasPostProcessor;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentsService
implements ComponentsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentsService.class);
    private final ModelConverters converter = ModelConverters.getInstance();
    private final List<SchemasPostProcessor> schemaPostProcessors;
    private final SwaggerSchemaUtil swaggerSchemaUtil;
    private final SpringwolfConfigProperties properties;
    private final Map<String, Schema> schemas = new HashMap<String, Schema>();
    private final Map<String, Message> messages = new HashMap<String, Message>();

    public DefaultComponentsService(List<ModelConverter> externalModelConverters, List<SchemasPostProcessor> schemaPostProcessors, SwaggerSchemaUtil swaggerSchemaUtil, SpringwolfConfigProperties properties) {
        externalModelConverters.forEach(arg_0 -> ((ModelConverters)this.converter).addConverter(arg_0));
        this.schemaPostProcessors = schemaPostProcessors;
        this.swaggerSchemaUtil = swaggerSchemaUtil;
        this.properties = properties;
    }

    @Override
    public Map<String, SchemaObject> getSchemas() {
        return this.schemas.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.swaggerSchemaUtil.mapSchema((Schema)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public String registerSchema(AsyncHeaders headers) {
        log.debug("Registering schema for {}", (Object)headers.getSchemaName());
        MapSchema headerSchema = new MapSchema();
        headerSchema.setName(headers.getSchemaName());
        headerSchema.setDescription(headers.getDescription());
        headerSchema.properties((Map)headers);
        this.schemas.put(headers.getSchemaName(), (Schema)headerSchema);
        this.postProcessSchema((Schema)headerSchema, "application/json");
        return headers.getSchemaName();
    }

    @Override
    public String registerSchema(Class<?> type) {
        return this.registerSchema(type, this.properties.getDocket().getDefaultContentType());
    }

    @Override
    public String registerSchema(Class<?> type, String contentType) {
        log.debug("Registering schema for {}", (Object)type.getSimpleName());
        String actualContentType = StringUtils.isBlank((CharSequence)contentType) ? this.properties.getDocket().getDefaultContentType() : contentType;
        LinkedHashMap<String, Schema> schemas = new LinkedHashMap<String, Schema>(this.runWithFqnSetting(unused -> this.converter.readAll((Type)type)));
        String schemaName = this.getSchemaName(type, schemas);
        this.preProcessSchemas(schemas, schemaName, type);
        schemas.forEach(this.schemas::putIfAbsent);
        schemas.values().forEach(schema -> this.postProcessSchema((Schema)schema, actualContentType));
        return schemaName;
    }

    @Override
    public Map<String, Message> getMessages() {
        return this.messages;
    }

    @Override
    public MessageReference registerMessage(MessageObject message) {
        log.debug("Registering message for {}", (Object)message.getName());
        this.messages.putIfAbsent(message.getName(), (Message)message);
        return MessageReference.toComponentMessage((MessageObject)message);
    }

    private String getSchemaName(Class<?> type, Map<String, Schema> schemas) {
        if (schemas.isEmpty() && type.equals(String.class)) {
            return this.registerString();
        }
        if (schemas.size() == 1) {
            return new ArrayList<String>(schemas.keySet()).get(0);
        }
        Set resolvedPayloadModelName = this.runWithFqnSetting(unused -> this.converter.read((Type)type).keySet());
        if (!resolvedPayloadModelName.isEmpty()) {
            return (String)new ArrayList(resolvedPayloadModelName).get(0);
        }
        return type.getSimpleName();
    }

    private void preProcessSchemas(Map<String, Schema> schemas, String schemaName, Class<?> type) {
        this.processAsyncApiPayloadAnnotation(schemas, schemaName, type);
    }

    private void processAsyncApiPayloadAnnotation(Map<String, Schema> schemas, String schemaName, Class<?> type) {
        List<Field> withPayloadAnnotatedFields = Arrays.stream(type.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AsyncApiPayload.class)).toList();
        if (withPayloadAnnotatedFields.size() == 1) {
            Schema envelopSchema = schemas.get(schemaName);
            if (envelopSchema != null && envelopSchema.getProperties() != null) {
                String fieldName = withPayloadAnnotatedFields.get(0).getName();
                Schema actualSchema = (Schema)envelopSchema.getProperties().get(fieldName);
                if (actualSchema != null) {
                    schemas.put(schemaName, actualSchema);
                }
            }
        } else if (withPayloadAnnotatedFields.size() > 1) {
            log.warn("Found more than one field with @AsyncApiPayload annotation in class %s. Falling back and ignoring annotation.".formatted(type.getName()));
        }
    }

    private String registerString() {
        String schemaName = "String";
        StringSchema schema = new StringSchema();
        schema.setName(String.class.getName());
        this.schemas.put(schemaName, (Schema)schema);
        this.postProcessSchema((Schema)schema, "application/json");
        return schemaName;
    }

    private <R> R runWithFqnSetting(Function<Void, R> callable) {
        boolean previousUseFqn = TypeNameResolver.std.getUseFqn();
        TypeNameResolver.std.setUseFqn(this.properties.isUseFqn());
        R result = callable.apply(null);
        TypeNameResolver.std.setUseFqn(previousUseFqn);
        return result;
    }

    private void postProcessSchema(Schema schema, String contentType) {
        for (SchemasPostProcessor processor : this.schemaPostProcessors) {
            processor.process(schema, this.schemas, contentType);
            if (this.schemas.containsValue(schema)) continue;
            break;
        }
    }
}

