/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common;

import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageHeaders;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessagePayload;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.operation.OperationAction;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaReference;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeaders;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.MessageBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.OperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.utils.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.common.utils.AsyncAnnotationUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public abstract class AsyncAnnotationScanner<A extends Annotation>
implements EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationScanner.class);
    protected final AsyncAnnotationProvider<A> asyncAnnotationProvider;
    protected final PayloadClassExtractor payloadClassExtractor;
    protected final ComponentsService componentsService;
    protected final List<OperationBindingProcessor> operationBindingProcessors;
    protected final List<MessageBindingProcessor> messageBindingProcessors;
    protected StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    protected Stream<MethodAndAnnotation<A>> getAnnotatedMethods(Class<?> type) {
        Class annotationClass = this.asyncAnnotationProvider.getAnnotation();
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)type.getName(), (Object)annotationClass.getName());
        return Arrays.stream(type.getDeclaredMethods()).filter(method -> !method.isBridge()).filter(method -> AnnotationScannerUtil.findAnnotation(annotationClass, method) != null).peek(method -> log.debug("Mapping method \"{}\" to channels", (Object)method.getName())).flatMap(method -> AnnotationScannerUtil.findAnnotations(annotationClass, method).stream().map(annotation -> new MethodAndAnnotation<Annotation>((Method)method, (Annotation)annotation)));
    }

    protected Operation buildOperation(AsyncOperation asyncOperation, Method method, String channelName) {
        String description = this.resolver.resolveStringValue(asyncOperation.description());
        if (!StringUtils.hasText((String)description)) {
            description = "Auto-generated description";
        }
        String operationTitle = channelName + "_" + this.asyncAnnotationProvider.getOperationType().type;
        Map<String, OperationBinding> operationBinding = AsyncAnnotationUtil.processOperationBindingFromAnnotation(method, this.operationBindingProcessors);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        MessageObject message = this.buildMessage(asyncOperation, method);
        return Operation.builder().channel(ChannelReference.fromChannel((String)channelName)).description(description).title(operationTitle).messages(List.of(MessageReference.toChannelMessage((String)channelName, (MessageObject)message))).bindings(opBinding).build();
    }

    protected MessageObject buildMessage(AsyncOperation operationData, Method method) {
        Class<?> payloadType = operationData.payloadType() != Object.class ? operationData.payloadType() : this.payloadClassExtractor.extractFrom(method);
        String modelName = this.componentsService.registerSchema(payloadType, operationData.message().contentType());
        AsyncHeaders asyncHeaders = AsyncAnnotationUtil.getAsyncHeaders(operationData, this.resolver);
        String headerModelName = this.componentsService.registerSchema(asyncHeaders);
        MessageHeaders headers = MessageHeaders.of((MessageReference)MessageReference.toSchema((String)headerModelName));
        Schema schema = payloadType.getAnnotation(Schema.class);
        String description = schema != null ? schema.description() : null;
        Map<String, MessageBinding> messageBinding = AsyncAnnotationUtil.processMessageBindingFromAnnotation(method, this.messageBindingProcessors);
        MessagePayload messagePayload = MessagePayload.of((MultiFormatSchema)MultiFormatSchema.builder().schema((Object)SchemaReference.fromSchema((String)modelName)).build());
        MessageObject.MessageObjectBuilder builder = MessageObject.builder().messageId(payloadType.getName()).name(payloadType.getName()).title(payloadType.getSimpleName()).description(description).payload(messagePayload).headers(headers).bindings(messageBinding);
        AsyncAnnotationUtil.processAsyncMessageAnnotation(builder, operationData.message(), this.resolver);
        MessageObject message = builder.build();
        this.componentsService.registerMessage(message);
        return message;
    }

    public AsyncAnnotationScanner(AsyncAnnotationProvider<A> asyncAnnotationProvider, PayloadClassExtractor payloadClassExtractor, ComponentsService componentsService, List<OperationBindingProcessor> operationBindingProcessors, List<MessageBindingProcessor> messageBindingProcessors) {
        this.asyncAnnotationProvider = asyncAnnotationProvider;
        this.payloadClassExtractor = payloadClassExtractor;
        this.componentsService = componentsService;
        this.operationBindingProcessors = operationBindingProcessors;
        this.messageBindingProcessors = messageBindingProcessors;
    }

    public static interface AsyncAnnotationProvider<A> {
        public Class<A> getAnnotation();

        public AsyncOperation getAsyncOperation(A var1);

        public OperationAction getOperationType();
    }

    protected record MethodAndAnnotation<A>(Method method, A annotation) {
    }
}

