/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common;

import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageHeaders;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessagePayload;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaReference;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeadersBuilder;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.common.MessageHelper;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.utils.AnnotationScannerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class ClassLevelAnnotationScanner<ClassAnnotation extends Annotation, MethodAnnotation extends Annotation> {
    private static final Logger log = LoggerFactory.getLogger(ClassLevelAnnotationScanner.class);
    protected final Class<ClassAnnotation> classAnnotationClass;
    protected final Class<MethodAnnotation> methodAnnotationClass;
    protected final BindingFactory<ClassAnnotation> bindingFactory;
    protected final AsyncHeadersBuilder asyncHeadersBuilder;
    protected final PayloadClassExtractor payloadClassExtractor;
    protected final ComponentsService componentsService;

    protected boolean isClassAnnotated(Class<?> component) {
        return AnnotationScannerUtil.findAnnotation(this.classAnnotationClass, component) != null;
    }

    protected Set<Method> getAnnotatedMethods(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.methodAnnotationClass.getName());
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> !method.isBridge()).filter(method -> AnnotationUtils.findAnnotation((Method)method, this.methodAnnotationClass) != null).collect(Collectors.toSet());
    }

    protected Map<String, MessageReference> buildMessages(ClassAnnotation classAnnotation, Set<Method> methods, MessageType messageType) {
        Set<MessageObject> messages = methods.stream().map(method -> {
            Class<?> payloadType = this.payloadClassExtractor.extractFrom((Method)method);
            return this.buildMessage(classAnnotation, payloadType);
        }).collect(Collectors.toSet());
        if (messageType == MessageType.OPERATION) {
            String channelName = this.bindingFactory.getChannelName(classAnnotation);
            return MessageHelper.toOperationsMessagesMap(channelName, messages);
        }
        return MessageHelper.toMessagesMap(messages);
    }

    protected MessageObject buildMessage(ClassAnnotation classAnnotation, Class<?> payloadType) {
        Map<String, MessageBinding> messageBinding = this.bindingFactory.buildMessageBinding(classAnnotation);
        String modelName = this.componentsService.registerSchema(payloadType);
        String headerModelName = this.componentsService.registerSchema(this.asyncHeadersBuilder.buildHeaders(payloadType));
        MessagePayload payload = MessagePayload.of((MultiFormatSchema)MultiFormatSchema.builder().schema((Object)SchemaReference.fromSchema((String)modelName)).build());
        MessageObject message = MessageObject.builder().messageId(payloadType.getName()).name(payloadType.getName()).title(payloadType.getSimpleName()).description(null).payload(payload).headers(MessageHeaders.of((MessageReference)MessageReference.toSchema((String)headerModelName))).bindings(messageBinding).build();
        this.componentsService.registerMessage(message);
        return message;
    }

    public ClassLevelAnnotationScanner(Class<ClassAnnotation> classAnnotationClass, Class<MethodAnnotation> methodAnnotationClass, BindingFactory<ClassAnnotation> bindingFactory, AsyncHeadersBuilder asyncHeadersBuilder, PayloadClassExtractor payloadClassExtractor, ComponentsService componentsService) {
        this.classAnnotationClass = classAnnotationClass;
        this.methodAnnotationClass = methodAnnotationClass;
        this.bindingFactory = bindingFactory;
        this.asyncHeadersBuilder = asyncHeadersBuilder;
        this.payloadClassExtractor = payloadClassExtractor;
        this.componentsService = componentsService;
    }

    protected static enum MessageType {
        CHANNEL,
        OPERATION;

    }
}

