/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.utils;

import io.github.springwolf.asyncapi.v3.bindings.ChannelBinding;
import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.core.asyncapi.annotations.AsyncMessage;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeaderSchema;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeaders;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeadersNotDocumented;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeadersNotUsed;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.ChannelBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.ProcessedChannelBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.MessageBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.ProcessedMessageBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.OperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.ProcessedOperationBinding;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class AsyncAnnotationUtil {
    private AsyncAnnotationUtil() {
    }

    public static AsyncHeaders getAsyncHeaders(AsyncOperation op, StringValueResolver resolver) {
        if (op.headers().values().length == 0) {
            if (op.headers().notUsed()) {
                return AsyncHeadersNotUsed.NOT_USED;
            }
            return AsyncHeadersNotDocumented.NOT_DOCUMENTED;
        }
        String headerDescription = StringUtils.hasText((String)op.headers().description()) ? resolver.resolveStringValue(op.headers().description()) : null;
        AsyncHeaders asyncHeaders = new AsyncHeaders(op.headers().schemaName(), headerDescription);
        Arrays.stream(op.headers().values()).collect(Collectors.groupingBy(AsyncOperation.Headers.Header::name)).forEach((headerName, headers) -> {
            List<String> values = AsyncAnnotationUtil.getHeaderValues(headers, resolver);
            String exampleValue = values.stream().findFirst().orElse(null);
            asyncHeaders.addHeader(AsyncHeaderSchema.headerBuilder().headerName(resolver.resolveStringValue(headerName)).description(AsyncAnnotationUtil.getDescription(headers, resolver)).enumValue(values).example(exampleValue).build());
        });
        return asyncHeaders;
    }

    private static List<String> getHeaderValues(List<AsyncOperation.Headers.Header> value, StringValueResolver resolver) {
        return value.stream().map(AsyncOperation.Headers.Header::value).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).sorted().toList();
    }

    private static String getDescription(List<AsyncOperation.Headers.Header> value, StringValueResolver resolver) {
        return value.stream().map(AsyncOperation.Headers.Header::description).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).filter(StringUtils::hasText).sorted().findFirst().orElse(null);
    }

    public static Map<String, OperationBinding> processOperationBindingFromAnnotation(Method method, List<OperationBindingProcessor> operationBindingProcessors) {
        return operationBindingProcessors.stream().map(operationBindingProcessor -> operationBindingProcessor.process(method)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedOperationBinding::getType, ProcessedOperationBinding::getBinding, (e1, e2) -> e1));
    }

    public static Map<String, MessageBinding> processMessageBindingFromAnnotation(Method method, List<MessageBindingProcessor> messageBindingProcessors) {
        return messageBindingProcessors.stream().map(messageBindingProcessor -> messageBindingProcessor.process(method)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedMessageBinding::getType, ProcessedMessageBinding::getBinding, (e1, e2) -> e1));
    }

    public static void processAsyncMessageAnnotation(MessageObject.MessageObjectBuilder messageBuilder, AsyncMessage asyncMessage, StringValueResolver resolver) {
        String annotationTitle;
        String annotationName;
        String annotationMessageId;
        String annotationMessageDescription = resolver.resolveStringValue(asyncMessage.description());
        if (StringUtils.hasText((String)annotationMessageDescription)) {
            messageBuilder.description(annotationMessageDescription);
        }
        if (StringUtils.hasText((String)(annotationMessageId = resolver.resolveStringValue(asyncMessage.messageId())))) {
            messageBuilder.messageId(annotationMessageId);
        }
        if (StringUtils.hasText((String)(annotationName = resolver.resolveStringValue(asyncMessage.name())))) {
            messageBuilder.name(annotationName);
        }
        if (StringUtils.hasText((String)(annotationTitle = resolver.resolveStringValue(asyncMessage.title())))) {
            messageBuilder.title(annotationTitle);
        }
        if (StringUtils.hasText((String)asyncMessage.contentType())) {
            messageBuilder.contentType(asyncMessage.contentType());
        }
    }

    public static List<String> getServers(AsyncOperation op, StringValueResolver resolver) {
        return Arrays.stream(op.servers()).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).toList();
    }

    public static Map<String, ChannelBinding> processChannelBindingFromAnnotation(Method method, List<ChannelBindingProcessor> channelBindingProcessors) {
        return channelBindingProcessors.stream().map(channelBindingProcessor -> channelBindingProcessor.process(method)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedChannelBinding::getType, ProcessedChannelBinding::getBinding, (e1, e2) -> e1));
    }
}

