/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations;

import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OperationMerger {
    private OperationMerger() {
    }

    public static Map<String, Operation> mergeOperations(List<Map.Entry<String, Operation>> operationEntries) {
        HashMap<String, Operation> mergedOperations = new HashMap<String, Operation>();
        for (Map.Entry<String, Operation> entry : operationEntries) {
            if (!mergedOperations.containsKey(entry.getKey())) {
                mergedOperations.put(entry.getKey(), entry.getValue());
                continue;
            }
            Operation operation = OperationMerger.mergeOperation((Operation)mergedOperations.get(entry.getKey()), entry.getValue());
            mergedOperations.put(entry.getKey(), operation);
        }
        return mergedOperations;
    }

    private static Operation mergeOperation(Operation operation, Operation otherOperation) {
        Operation mergedOperation = operation != null ? operation : otherOperation;
        List<MessageReference> mergedMessages = OperationMerger.mergeMessageReferences(operation.getMessages(), otherOperation.getMessages());
        if (!mergedMessages.isEmpty()) {
            mergedOperation.setMessages(mergedMessages);
        }
        return mergedOperation;
    }

    private static List<MessageReference> mergeMessageReferences(Collection<MessageReference> messages, Collection<MessageReference> otherMessages) {
        HashSet<MessageReference> messageReferences = new HashSet<MessageReference>();
        if (messages != null) {
            messageReferences.addAll(messages);
        }
        if (otherMessages != null) {
            messageReferences.addAll(otherMessages);
        }
        return messageReferences.stream().toList();
    }
}

