/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations.annotations;

import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.scanners.OperationsScanner;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.MessageBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.OperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.classes.ClassScanner;
import io.github.springwolf.core.asyncapi.scanners.common.AsyncAnnotationScanner;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationMerger;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAnnotationOperationsScanner<A extends Annotation>
extends AsyncAnnotationScanner<A>
implements OperationsScanner {
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationOperationsScanner.class);
    private final ClassScanner classScanner;

    public AsyncAnnotationOperationsScanner(AsyncAnnotationScanner.AsyncAnnotationProvider<A> asyncAnnotationProvider, ClassScanner classScanner, ComponentsService componentsService, PayloadClassExtractor payloadClassExtractor, List<OperationBindingProcessor> operationBindingProcessors, List<MessageBindingProcessor> messageBindingProcessors) {
        super(asyncAnnotationProvider, payloadClassExtractor, componentsService, operationBindingProcessors, messageBindingProcessors);
        this.classScanner = classScanner;
    }

    @Override
    public Map<String, Operation> scan() {
        List<Map.Entry<String, Operation>> operations = this.classScanner.scan().stream().flatMap(x$0 -> this.getAnnotatedMethods((Class<?>)x$0)).map(this::buildOperation).toList();
        return OperationMerger.mergeOperations(operations);
    }

    private Map.Entry<String, Operation> buildOperation(AsyncAnnotationScanner.MethodAndAnnotation<A> methodAndAnnotation) {
        AsyncOperation operationAnnotation = this.asyncAnnotationProvider.getAsyncOperation((Annotation)methodAndAnnotation.annotation());
        String channelName = this.resolver.resolveStringValue(operationAnnotation.channelName());
        String operationId = channelName + "_" + this.asyncAnnotationProvider.getOperationType().type + "_" + methodAndAnnotation.method().getName();
        Operation operation = this.buildOperation(operationAnnotation, methodAndAnnotation.method(), channelName);
        operation.setAction(this.asyncAnnotationProvider.getOperationType());
        return Map.entry(operationId, operation);
    }
}

