/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations.annotations;

import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.operation.OperationAction;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeadersBuilder;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.common.ClassLevelAnnotationScanner;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.utils.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.operations.annotations.SpringAnnotationOperationsScannerDelegator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationClassLevelOperationsScanner<ClassAnnotation extends Annotation, MethodAnnotation extends Annotation>
extends ClassLevelAnnotationScanner<ClassAnnotation, MethodAnnotation>
implements SpringAnnotationOperationsScannerDelegator {
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationClassLevelOperationsScanner.class);

    public SpringAnnotationClassLevelOperationsScanner(Class<ClassAnnotation> classAnnotationClass, Class<MethodAnnotation> methodAnnotationClass, BindingFactory<ClassAnnotation> bindingFactory, AsyncHeadersBuilder asyncHeadersBuilder, PayloadClassExtractor payloadClassExtractor, ComponentsService componentsService) {
        super(classAnnotationClass, methodAnnotationClass, bindingFactory, asyncHeadersBuilder, payloadClassExtractor, componentsService);
    }

    @Override
    public Stream<Map.Entry<String, Operation>> scan(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.classAnnotationClass.getName());
        return Stream.of(clazz).filter(x$0 -> this.isClassAnnotated((Class<?>)x$0)).flatMap(this::mapClassToOperation);
    }

    private Stream<Map.Entry<String, Operation>> mapClassToOperation(Class<?> component) {
        log.debug("Mapping class \"{}\" to operations", (Object)component.getName());
        Object classAnnotation = AnnotationScannerUtil.findAnnotationOrThrow(this.classAnnotationClass, component);
        Set<Method> annotatedMethods = this.getAnnotatedMethods(component);
        if (annotatedMethods.isEmpty()) {
            return Stream.empty();
        }
        String channelName = this.bindingFactory.getChannelName(classAnnotation);
        String operationId = channelName + "_" + OperationAction.RECEIVE + "_" + component.getSimpleName();
        Operation operation = this.buildOperation(classAnnotation, annotatedMethods);
        return Stream.of(Map.entry(operationId, operation));
    }

    private Operation buildOperation(ClassAnnotation classAnnotation, Set<Method> methods) {
        Map<String, MessageReference> messages = this.buildMessages(classAnnotation, methods, ClassLevelAnnotationScanner.MessageType.OPERATION);
        return this.buildOperation(classAnnotation, messages);
    }

    private Operation buildOperation(ClassAnnotation classAnnotation, Map<String, MessageReference> messages) {
        Map<String, OperationBinding> operationBinding = this.bindingFactory.buildOperationBinding(classAnnotation);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        String channelName = this.bindingFactory.getChannelName(classAnnotation);
        return Operation.builder().action(OperationAction.RECEIVE).channel(ChannelReference.fromChannel((String)channelName)).messages(messages.values().stream().toList()).bindings(opBinding).build();
    }
}

