/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.springwolf.asyncapi.v3.jackson.AsyncApiSerializerService;
import io.github.springwolf.asyncapi.v3.jackson.DefaultAsyncApiSerializerService;
import io.github.springwolf.core.asyncapi.AsyncApiService;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.controller.ActuatorAsyncApiController;
import io.github.springwolf.core.controller.AsyncApiController;
import io.github.springwolf.core.controller.PublishingPayloadCreator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class SpringwolfWebConfiguration {
    @Bean
    @ConditionalOnProperty(name={"springwolf.endpoint.actuator.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public AsyncApiController asyncApiController(AsyncApiService asyncApiService, AsyncApiSerializerService asyncApiSerializerService) {
        return new AsyncApiController(asyncApiService, asyncApiSerializerService);
    }

    @Bean
    @ConditionalOnMissingBean
    public PublishingPayloadCreator publishingPayloadCreator(ComponentsService componentsService, ObjectMapper objectMapper) {
        return new PublishingPayloadCreator(componentsService, objectMapper);
    }

    @Bean
    @ConditionalOnProperty(name={"springwolf.endpoint.actuator.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public ActuatorAsyncApiController actuatorAsyncApiController(AsyncApiService asyncApiService, AsyncApiSerializerService asyncApiSerializerService) {
        return new ActuatorAsyncApiController(asyncApiService, asyncApiSerializerService);
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncApiSerializerService asyncApiSerializerService() {
        return new DefaultAsyncApiSerializerService();
    }
}

