/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.controller;

import io.github.springwolf.core.controller.PublishingPayloadCreator;
import io.github.springwolf.core.controller.dtos.MessageDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class PublishingBaseController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PublishingBaseController.class);
    private final PublishingPayloadCreator publishingPayloadCreator;

    protected abstract boolean isEnabled();

    protected abstract void publishMessage(String var1, MessageDto var2, Object var3);

    @PostMapping(value={"/publish"})
    public ResponseEntity<String> publish(@RequestParam String topic, @RequestBody MessageDto message) {
        if (!this.isEnabled()) {
            String errorMessage = "Publishing using %s is not enabled - message will not be published".formatted(this.getClass().getSimpleName());
            log.warn(errorMessage);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)errorMessage);
        }
        PublishingPayloadCreator.Result result = this.publishingPayloadCreator.createPayloadObject(message);
        if (result.payload() != null) {
            this.publishMessage(topic, message, result.payload());
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)result.errorMessage());
    }

    public void afterPropertiesSet() {
        log.debug("Message publishing via %s is active.".formatted(this.getClass().getSimpleName()));
    }

    public PublishingBaseController(PublishingPayloadCreator publishingPayloadCreator) {
        this.publishingPayloadCreator = publishingPayloadCreator;
    }
}

