/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.bindings.processor;

import com.asyncapi.v2.binding.operation.OperationBinding;
import com.asyncapi.v2.binding.operation.kafka.KafkaOperationBinding;
import com.asyncapi.v2.schema.Schema;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.ProcessedOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.processor.AbstractOperationBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.KafkaListenerUtil;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.KafkaAsyncOperationBinding;
import org.springframework.util.StringUtils;

public class KafkaOperationBindingProcessor
extends AbstractOperationBindingProcessor<KafkaAsyncOperationBinding> {
    protected ProcessedOperationBinding mapToOperationBinding(KafkaAsyncOperationBinding bindingAnnotation) {
        String clientId = this.resolveOrNull(bindingAnnotation.clientId());
        Schema clientIdSchema = KafkaListenerUtil.buildKafkaClientIdSchema(clientId);
        String groupId = this.resolveOrNull(bindingAnnotation.groupId());
        Schema groupIdSchema = KafkaListenerUtil.buildKafkaGroupIdSchema(groupId);
        KafkaOperationBinding.KafkaOperationBindingBuilder kafkaOperationBindingBuilder = KafkaOperationBinding.builder();
        kafkaOperationBindingBuilder.clientId((Object)clientIdSchema).groupId((Object)groupIdSchema);
        String bindingVersion = this.resolveOrNull(bindingAnnotation.bindingVersion());
        if (StringUtils.hasText((String)bindingVersion)) {
            kafkaOperationBindingBuilder.bindingVersion(bindingVersion);
        }
        return new ProcessedOperationBinding(bindingAnnotation.type(), (OperationBinding)kafkaOperationBindingBuilder.build());
    }
}

