/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.kafka.asyncapi.scanners.bindings.messages;

import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaMessageBinding;
import io.github.springwolf.asyncapi.v3.model.schema.Schema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.MessageBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.ProcessedMessageBinding;
import io.github.springwolf.plugins.kafka.asyncapi.annotations.KafkaAsyncOperationBinding;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class KafkaMessageBindingProcessor
implements MessageBindingProcessor,
EmbeddedValueResolverAware {
    private StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Optional<ProcessedMessageBinding> process(Method method) {
        return Arrays.stream(method.getAnnotations()).filter(annotation -> annotation instanceof KafkaAsyncOperationBinding).map(annotation -> (KafkaAsyncOperationBinding)annotation).findAny().map(this::mapToMessageBinding);
    }

    private ProcessedMessageBinding mapToMessageBinding(KafkaAsyncOperationBinding bindingAnnotation) {
        KafkaAsyncOperationBinding.KafkaAsyncMessageBinding messageBinding = bindingAnnotation.messageBinding();
        KafkaMessageBinding.KafkaMessageBindingBuilder kafkaMessageBindingBuilder = KafkaMessageBinding.builder();
        kafkaMessageBindingBuilder.key(this.resolveSchemaOrNull(messageBinding));
        String bindingVersion = this.resolveOrNull(messageBinding.bindingVersion());
        if (StringUtils.hasText((String)bindingVersion)) {
            kafkaMessageBindingBuilder.bindingVersion(bindingVersion);
        }
        return new ProcessedMessageBinding(bindingAnnotation.type(), (MessageBinding)kafkaMessageBindingBuilder.build());
    }

    private String resolveOrNull(String stringValue) {
        return StringUtils.hasText((String)stringValue) ? this.resolver.resolveStringValue(stringValue) : null;
    }

    private Schema resolveSchemaOrNull(KafkaAsyncOperationBinding.KafkaAsyncMessageBinding messageBinding) {
        SchemaObject schemaDefinition = null;
        switch (messageBinding.key().type()) {
            case UNDEFINED_KEY: {
                break;
            }
            case STRING_KEY: {
                schemaDefinition = SchemaObject.builder().type("string").examples(List.of(messageBinding.key().example())).description(this.resolveOrNull(messageBinding.key().description())).build();
            }
        }
        return schemaDefinition;
    }
}

