/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.jp;

import com.microsoft.playwright.APIRequest;
import com.microsoft.playwright.APIRequestContext;
import com.microsoft.playwright.Playwright;
import io.github.uchagani.jp.AnnotationUtils;
import io.github.uchagani.jp.ExtensionUtils;
import io.github.uchagani.jp.PlaywrightParameterResolver;
import io.github.uchagani.jp.RestConfig;
import io.github.uchagani.jp.UseRestConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class APIRequestContextParameterResolver
implements ParameterResolver {
    private static final String id = ".apiRequestContext.";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return parameterType.equals(APIRequestContext.class) && (parameterContext.isAnnotated(UseRestConfig.class) || AnnotationUtils.isAnnotationPresentOnClassOrMethod(extensionContext, UseRestConfig.class));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return APIRequestContextParameterResolver.getAPIRequestContext(parameterContext, extensionContext);
    }

    public static void closeAPIRequestContext(ExtensionContext extensionContext) {
        APIRequestContext apiRequestContext = ExtensionUtils.getObjectFromStore(extensionContext, id, APIRequestContext.class);
        if (apiRequestContext != null) {
            apiRequestContext.dispose();
        }
    }

    private static Playwright getPlaywright(ExtensionContext extensionContext) {
        try {
            return PlaywrightParameterResolver.getPlaywright(extensionContext);
        }
        catch (Exception ex) {
            Playwright playwright = Playwright.create();
            PlaywrightParameterResolver.savePlaywrightInStore(extensionContext, playwright);
            return playwright;
        }
    }

    public static APIRequestContext getAPIRequestContext(ParameterContext parameterContext, ExtensionContext extensionContext) {
        RestConfig restConfig = ExtensionUtils.getRestConfig(parameterContext, extensionContext);
        Playwright playwright = APIRequestContextParameterResolver.getPlaywright(extensionContext);
        return APIRequestContextParameterResolver.createAPIRequestContext(playwright, restConfig);
    }

    public static void saveAPIRequestContextInStore(ExtensionContext extensionContext, APIRequestContext apiRequestContext) {
        ExtensionUtils.saveObjectInStore(extensionContext, id, apiRequestContext);
    }

    private static APIRequestContext createAPIRequestContext(Playwright playwright, RestConfig restConfig) {
        APIRequest.NewContextOptions options = restConfig.getAPIRequestContextOptions();
        if (options == null) {
            return playwright.request().newContext();
        }
        return playwright.request().newContext(options);
    }
}

