/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.jp;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Tracing;
import io.github.uchagani.jp.AnnotationUtils;
import io.github.uchagani.jp.BrowserConfig;
import io.github.uchagani.jp.BrowserCreateMethod;
import io.github.uchagani.jp.BrowserParameterResolver;
import io.github.uchagani.jp.ExtensionUtils;
import io.github.uchagani.jp.UseBrowserConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class BrowserContextParameterResolver
implements ParameterResolver {
    private static final String id = ".browserContext.";

    public static BrowserContext getBrowserContext(ExtensionContext extensionContext) {
        BrowserContext browserContext = ExtensionUtils.getObjectFromStore(extensionContext, id, BrowserContext.class);
        if (browserContext == null) {
            Browser browser = BrowserParameterResolver.getBrowser(extensionContext);
            BrowserConfig browserConfig = ExtensionUtils.getBrowserConfig(extensionContext);
            if (browserConfig.getCreateMethod() == BrowserCreateMethod.LAUNCH_PERSISTENT_CONTEXT) {
                return BrowserContextParameterResolver.getBrowserContext(extensionContext);
            }
            browserContext = BrowserContextParameterResolver.createBrowserContext(browser, browserConfig);
            if (browserConfig.getEnableTracing()) {
                browserContext.tracing().start(BrowserContextParameterResolver.getTraceStartOptions());
            }
            BrowserContextParameterResolver.saveBrowserContextInStore(extensionContext, browserContext);
        }
        return browserContext;
    }

    public static void saveBrowserContextInStore(ExtensionContext extensionContext, BrowserContext browserContext) {
        ExtensionUtils.saveObjectInStore(extensionContext, id, browserContext);
    }

    private static BrowserContext createBrowserContext(Browser browser, BrowserConfig config) {
        Browser.NewContextOptions newContextOptions = config.getNewContextOptions();
        if (newContextOptions == null) {
            return browser.newContext();
        }
        return browser.newContext(newContextOptions);
    }

    private static Tracing.StartOptions getTraceStartOptions() {
        Tracing.StartOptions startOptions = new Tracing.StartOptions().setSnapshots(true).setScreenshots(true);
        if (System.getenv("PLAYWRIGHT_JAVA_SRC") != null) {
            startOptions.setSources(true);
        }
        return startOptions;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return AnnotationUtils.isAnnotationPresentOnClassOrMethod(extensionContext, UseBrowserConfig.class) && parameterType.equals(BrowserContext.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return BrowserContextParameterResolver.getBrowserContext(extensionContext);
    }
}

