/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.jp;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Playwright;
import io.github.uchagani.jp.AnnotationUtils;
import io.github.uchagani.jp.BrowserChoice;
import io.github.uchagani.jp.BrowserConfig;
import io.github.uchagani.jp.BrowserContextParameterResolver;
import io.github.uchagani.jp.BrowserCreateMethod;
import io.github.uchagani.jp.ExtensionUtils;
import io.github.uchagani.jp.PlaywrightParameterResolver;
import io.github.uchagani.jp.UseBrowserConfig;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class BrowserParameterResolver
implements ParameterResolver {
    static final String id = ".browser.";
    static final Map<BrowserChoice, BrowserType> browserChoiceMap = new HashMap<BrowserChoice, BrowserType>();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return AnnotationUtils.isAnnotationPresentOnClassOrMethod(extensionContext, UseBrowserConfig.class) && parameterType.equals(Browser.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return BrowserParameterResolver.getBrowser(extensionContext);
    }

    private static BrowserType getBrowserType(BrowserChoice browserChoice, Playwright playwright) {
        switch (browserChoice) {
            case CHROMIUM: {
                return playwright.chromium();
            }
            case FIREFOX: {
                return playwright.firefox();
            }
            case WEBKIT: {
                return playwright.webkit();
            }
        }
        throw new RuntimeException("Unknown BrowserChoice");
    }

    private static Browser launch(BrowserType browserType, BrowserType.LaunchOptions options) {
        if (options == null) {
            return browserType.launch();
        }
        return browserType.launch(options);
    }

    private static Browser connect(BrowserType browserType, String wsEndpoint, BrowserType.ConnectOptions options) {
        if (options == null) {
            return browserType.connect(wsEndpoint);
        }
        return browserType.connect(wsEndpoint, options);
    }

    private static Browser connectOverCDP(BrowserType browserType, String wsEndpointUrl, BrowserType.ConnectOverCDPOptions options) {
        if (options == null) {
            return browserType.connectOverCDP(wsEndpointUrl);
        }
        return browserType.connectOverCDP(wsEndpointUrl, options);
    }

    private static BrowserContext launchPersistentContext(BrowserType browserType, Path userDir, BrowserType.LaunchPersistentContextOptions options) {
        if (options == null) {
            return browserType.launchPersistentContext(userDir);
        }
        return browserType.launchPersistentContext(userDir, options);
    }

    private static Browser createBrowser(BrowserConfig config, BrowserType browserType) {
        switch (config.getCreateMethod()) {
            case LAUNCH: {
                return BrowserParameterResolver.launch(browserType, config.getLaunchOptions());
            }
            case CONNECT: {
                return BrowserParameterResolver.connect(browserType, config.getWsEndpoint(), config.getConnectOptions());
            }
            case CONNECT_OVER_CDP: {
                return BrowserParameterResolver.connectOverCDP(browserType, config.getEndpointUrl(), config.getConnectOverCDPOptions());
            }
            case LAUNCH_PERSISTENT_CONTEXT: {
                BrowserContext browserContext = BrowserParameterResolver.launchPersistentContext(browserType, config.getUserDataDir(), config.getLaunchPersistentContextOptions());
                return browserContext.browser();
            }
        }
        throw new RuntimeException("Unknown BrowserCreateMethod");
    }

    public static Browser getBrowser(ExtensionContext extensionContext) {
        Browser browser = ExtensionUtils.getObjectFromStore(extensionContext, id, Browser.class);
        if (browser == null) {
            Playwright playwright = PlaywrightParameterResolver.getPlaywright(extensionContext);
            BrowserConfig config = ExtensionUtils.getBrowserConfig(extensionContext);
            BrowserType browserType = BrowserParameterResolver.getBrowserType(config.getBrowser(), playwright);
            browser = BrowserParameterResolver.createBrowser(config, browserType);
            BrowserParameterResolver.saveBrowserInStore(extensionContext, browser);
            if (config.getCreateMethod().equals((Object)BrowserCreateMethod.LAUNCH_PERSISTENT_CONTEXT)) {
                BrowserContextParameterResolver.saveBrowserContextInStore(extensionContext, (BrowserContext)browser.contexts().get(0));
            }
        }
        return browser;
    }

    public static void saveBrowserInStore(ExtensionContext extensionContext, Browser browser) {
        ExtensionUtils.saveObjectInStore(extensionContext, id, browser);
    }
}

