/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.jp;

import io.github.uchagani.jp.BrowserConfig;
import io.github.uchagani.jp.JunitPlaywright;
import io.github.uchagani.jp.PlaywrightBrowserConfig;
import io.github.uchagani.jp.PlaywrightRestConfig;
import io.github.uchagani.jp.RestConfig;
import io.github.uchagani.jp.UseBrowserConfig;
import io.github.uchagani.jp.UseRestConfig;
import java.lang.reflect.InvocationTargetException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

public class ExtensionUtils {
    static final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{JunitPlaywright.class});

    static void saveObjectInStore(ExtensionContext extensionContext, String id, Object object) {
        extensionContext.getStore(namespace).put((Object)(extensionContext.getUniqueId() + id), object);
    }

    static <T> T getObjectFromStore(ExtensionContext extensionContext, String id, Class<T> objectType) {
        return (T)extensionContext.getStore(namespace).get((Object)(extensionContext.getUniqueId() + id), objectType);
    }

    public static RestConfig getRestConfig(ParameterContext parameterContext, ExtensionContext extensionContext) {
        RestConfig config = ExtensionUtils.getObjectFromStore(extensionContext, ExtensionUtils.getRestConfigId(parameterContext, extensionContext), RestConfig.class);
        if (config == null) {
            Class<? extends PlaywrightRestConfig> configClass;
            try {
                configClass = parameterContext.getParameter().getAnnotation(UseRestConfig.class).value();
            }
            catch (Exception ignored) {
                try {
                    configClass = extensionContext.getRequiredTestMethod().getAnnotation(UseRestConfig.class).value();
                }
                catch (Exception ignored1) {
                    configClass = extensionContext.getRequiredTestClass().getAnnotation(UseRestConfig.class).value();
                }
            }
            config = ExtensionUtils.createInstanceOfConfig(configClass).getRestConfig();
            ExtensionUtils.saveRestConfigInStore(extensionContext, config);
        }
        return config;
    }

    public static void saveRestConfigInStore(ExtensionContext extensionContext, RestConfig config) {
        ExtensionUtils.saveObjectInStore(extensionContext, ExtensionUtils.getRestConfigId(null, extensionContext), config);
    }

    public static void saveBrowserConfigInStore(ExtensionContext extensionContext, BrowserConfig config) {
        ExtensionUtils.saveObjectInStore(extensionContext, ExtensionUtils.getBrowserConfigId(extensionContext), config);
    }

    public static BrowserConfig getBrowserConfig(ExtensionContext extensionContext) {
        BrowserConfig config = ExtensionUtils.getObjectFromStore(extensionContext, ExtensionUtils.getBrowserConfigId(extensionContext), BrowserConfig.class);
        if (config == null) {
            Class<? extends PlaywrightBrowserConfig> configClass;
            try {
                configClass = extensionContext.getRequiredTestMethod().getAnnotation(UseBrowserConfig.class).value();
            }
            catch (Exception ignored) {
                configClass = extensionContext.getRequiredTestClass().getAnnotation(UseBrowserConfig.class).value();
            }
            config = ExtensionUtils.createInstanceOfConfig(configClass).getBrowserConfig();
            ExtensionUtils.saveBrowserConfigInStore(extensionContext, config);
        }
        return config;
    }

    private static <T> T createInstanceOfConfig(Class<T> configClass) {
        try {
            return configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            String message = String.format("Unable to create instance of %s.  Ensure the class has a public default constructor.", configClass.getName());
            throw new RuntimeException(message, ex);
        }
    }

    private static String getBrowserConfigId(ExtensionContext extensionContext) {
        return extensionContext.getUniqueId() + ".browserConfigId.";
    }

    private static String getRestConfigId(ParameterContext parameterContext, ExtensionContext extensionContext) {
        String id = ".restConfigId.";
        if (parameterContext == null) {
            return extensionContext.getUniqueId() + id;
        }
        return extensionContext.getUniqueId() + id + parameterContext.getIndex();
    }
}

