/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.jp;

import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Page;
import io.github.uchagani.jp.AnnotationUtils;
import io.github.uchagani.jp.BrowserContextParameterResolver;
import io.github.uchagani.jp.ExtensionUtils;
import io.github.uchagani.jp.UseBrowserConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class PageParameterResolver
implements ParameterResolver {
    private static final String id = ".page.";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return AnnotationUtils.isAnnotationPresentOnClassOrMethod(extensionContext, UseBrowserConfig.class) && parameterType.equals(Page.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return PageParameterResolver.getPage(extensionContext);
    }

    public static Page getPage(ExtensionContext extensionContext) {
        Page page = ExtensionUtils.getObjectFromStore(extensionContext, id, Page.class);
        if (page == null) {
            BrowserContext browserContext = BrowserContextParameterResolver.getBrowserContext(extensionContext);
            page = browserContext.newPage();
            PageParameterResolver.savePageInStore(extensionContext, page);
        }
        return page;
    }

    public static void savePageInStore(ExtensionContext extensionContext, Page page) {
        ExtensionUtils.saveObjectInStore(extensionContext, id, page);
    }
}

