/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.jp;

import com.microsoft.playwright.Playwright;
import io.github.uchagani.jp.AnnotationUtils;
import io.github.uchagani.jp.BrowserConfig;
import io.github.uchagani.jp.ExtensionUtils;
import io.github.uchagani.jp.UseBrowserConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class PlaywrightParameterResolver
implements ParameterResolver {
    static final String id = ".playwright.";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return AnnotationUtils.isAnnotationPresentOnClassOrMethod(extensionContext, UseBrowserConfig.class) && parameterType.equals(Playwright.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return PlaywrightParameterResolver.getPlaywright(extensionContext);
    }

    static void closePlaywright(ExtensionContext extensionContext) {
        Playwright playwright = ExtensionUtils.getObjectFromStore(extensionContext, id, Playwright.class);
        if (playwright != null) {
            playwright.close();
        }
    }

    public static void savePlaywrightInStore(ExtensionContext extensionContext, Playwright playwright) {
        ExtensionUtils.saveObjectInStore(extensionContext, id, playwright);
    }

    public static Playwright getPlaywright(ExtensionContext extensionContext) {
        Playwright playwright = ExtensionUtils.getObjectFromStore(extensionContext, id, Playwright.class);
        if (playwright == null) {
            BrowserConfig config = ExtensionUtils.getBrowserConfig(extensionContext);
            Playwright.CreateOptions options = config.getPlaywrightCreateOptions();
            playwright = PlaywrightParameterResolver.createPlaywright(options);
            PlaywrightParameterResolver.savePlaywrightInStore(extensionContext, playwright);
        }
        return playwright;
    }

    private static Playwright createPlaywright(Playwright.CreateOptions options) {
        if (options == null) {
            return Playwright.create();
        }
        return Playwright.create((Playwright.CreateOptions)options);
    }
}

