/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.jp;

import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Tracing;
import io.github.uchagani.jp.APIRequestContextParameterResolver;
import io.github.uchagani.jp.BrowserConfig;
import io.github.uchagani.jp.BrowserContextParameterResolver;
import io.github.uchagani.jp.ExtensionUtils;
import io.github.uchagani.jp.PlaywrightParameterResolver;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class PlaywrightTestWatcher
implements TestWatcher {
    public void testSuccessful(ExtensionContext extensionContext) {
        BrowserConfig browserConfig = ExtensionUtils.getBrowserConfig(extensionContext);
        if (browserConfig.getEnableTracing() && !browserConfig.getSaveTraceOnlyOnFailure()) {
            this.stopTrace(extensionContext);
        }
        this.cleanup(extensionContext);
    }

    public void testAborted(ExtensionContext extensionContext, Throwable cause) {
        BrowserConfig browserConfig = ExtensionUtils.getBrowserConfig(extensionContext);
        if (browserConfig.getEnableTracing() && !browserConfig.getSaveTraceOnlyOnFailure()) {
            this.stopTrace(extensionContext);
        }
        this.cleanup(extensionContext);
    }

    public void testFailed(ExtensionContext extensionContext, Throwable cause) {
        BrowserConfig browserConfig = ExtensionUtils.getBrowserConfig(extensionContext);
        if (browserConfig.getEnableTracing()) {
            this.stopTrace(extensionContext);
        }
        this.cleanup(extensionContext);
    }

    private void stopTrace(ExtensionContext extensionContext) {
        BrowserConfig config = ExtensionUtils.getBrowserConfig(extensionContext);
        BrowserContext browserContext = BrowserContextParameterResolver.getBrowserContext(extensionContext);
        Path tracePath = Paths.get(String.valueOf(config.getOutputDirectory()), this.getSafeTestName(extensionContext));
        Tracing.StopOptions stopOptions = new Tracing.StopOptions().setPath(tracePath);
        browserContext.tracing().stop(stopOptions);
    }

    private String getSafeTestName(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestClass() + "." + extensionContext.getDisplayName() + ".zip";
    }

    private void cleanup(ExtensionContext extensionContext) {
        APIRequestContextParameterResolver.closeAPIRequestContext(extensionContext);
        PlaywrightParameterResolver.closePlaywright(extensionContext);
    }
}

