/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxLocation;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHeader;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.springframework.web.servlet.view.RedirectView;

public class HtmxLocationRedirectView
extends RedirectView {
    private final JsonMapper jsonMapper = new JsonMapper();
    private String source;
    private String event;
    private String handler;
    private String target;
    private String swap;
    private String select;
    private Map<String, Object> values;
    private Map<String, String> headers;

    public HtmxLocationRedirectView() {
    }

    public HtmxLocationRedirectView(String url) {
        super(url);
    }

    public HtmxLocationRedirectView(String url, boolean contextRelative) {
        super(url, contextRelative);
    }

    public HtmxLocationRedirectView(String url, boolean contextRelative, boolean exposeModelAttributes) {
        super(url, contextRelative, exposeModelAttributes);
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setSelect(String cssSelector) {
        this.select = cssSelector;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSwap(String swap) {
        this.swap = swap;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String targetUrl, boolean http10Compatible) throws IOException {
        String encodedURL = this.isRemoteHost(targetUrl) ? targetUrl : response.encodeRedirectURL(targetUrl);
        HtmxLocation location = this.createLocation(encodedURL);
        if (location.hasContextData()) {
            this.setHeaderAsJson(response, HtmxResponseHeader.HX_LOCATION.getValue(), location);
        } else {
            response.setHeader(HtmxResponseHeader.HX_LOCATION.getValue(), location.getPath());
        }
    }

    private HtmxLocation createLocation(String url) {
        HtmxLocation location = new HtmxLocation();
        location.setPath(url);
        location.setSource(this.source);
        location.setEvent(this.event);
        location.setHandler(this.handler);
        location.setTarget(this.target);
        location.setSwap(this.swap);
        location.setSelect(this.select);
        location.setValues(this.values);
        location.setHeaders(this.headers);
        return location;
    }

    private void setHeaderAsJson(HttpServletResponse response, String name, Object value) {
        try {
            response.setHeader(name, this.jsonMapper.writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to set header " + name + " to " + value, e);
        }
    }
}

