/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.HandledArgumentViolation;
import io.gitlab.arturbosch.detekt.cli.HelpRequest;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a+\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"parseArguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "args", "", "", "outPrinter", "Ljava/io/PrintStream;", "errorPrinter", "([Ljava/lang/String;Ljava/io/PrintStream;Ljava/io/PrintStream;)Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "usage", "", "Lcom/beust/jcommander/JCommander;", "detekt-cli"})
public final class JCommanderKt {
    @NotNull
    public static final CliArgs parseArguments(@NotNull String[] args, @NotNull PrintStream outPrinter, @NotNull PrintStream errorPrinter) {
        boolean bl;
        String string;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)outPrinter, (String)"outPrinter");
        Intrinsics.checkParameterIsNotNull((Object)errorPrinter, (String)"errorPrinter");
        CliArgs cli = new CliArgs();
        JCommander jCommander = new JCommander((Object)cli);
        jCommander.setProgramName("detekt");
        try {
            jCommander.parse(Arrays.copyOf(args, args.length));
        }
        catch (ParameterException ex) {
            errorPrinter.println(ex.getMessage() + '\n');
            JCommanderKt.usage(jCommander, outPrinter);
            throw (Throwable)new HandledArgumentViolation();
        }
        if (cli.getHelp()) {
            JCommanderKt.usage(jCommander, outPrinter);
            throw (Throwable)new HelpRequest();
        }
        boolean bl2 = false;
        List violations = new ArrayList();
        Path baseline = cli.getBaseline();
        if (cli.getCreateBaseline() && baseline == null) {
            collection = violations;
            string = "Creating a baseline.xml requires the --baseline parameter to specify a path.";
            bl = false;
            collection.add(string);
        }
        if (!cli.getCreateBaseline() && baseline != null) {
            if (!JunkKt.exists((Path)baseline)) {
                collection = violations;
                string = "The file specified by --baseline should exist '" + baseline + "'.";
                bl = false;
                collection.add(string);
            } else if (!JunkKt.isFile((Path)baseline)) {
                collection = violations;
                string = "The path specified by --baseline should be a file '" + baseline + "'.";
                bl = false;
                collection.add(string);
            }
        }
        collection = violations;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            Iterable $this$forEach$iv = violations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p1 = (String)element$iv;
                boolean bl4 = false;
                errorPrinter.println(p1);
            }
            errorPrinter.println();
            JCommanderKt.usage(jCommander, outPrinter);
            throw (Throwable)new HandledArgumentViolation();
        }
        return cli;
    }

    public static final void usage(@NotNull JCommander $this$usage, @NotNull PrintStream outPrinter) {
        Intrinsics.checkParameterIsNotNull((Object)$this$usage, (String)"$this$usage");
        Intrinsics.checkParameterIsNotNull((Object)outPrinter, (String)"outPrinter");
        StringBuilder usage = new StringBuilder();
        $this$usage.getUsageFormatter().usage(usage);
        outPrinter.println(usage.toString());
    }
}

