/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsWithHashCodeExist;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "queue", "Ljava/util/ArrayDeque;", "Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsWithHashCodeExist$ViolationHolder;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitFile", "file", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "ViolationHolder", "detekt-rules"})
public final class EqualsWithHashCodeExist
extends Rule {
    @NotNull
    private final Issue issue;
    private final ArrayDeque<ViolationHolder> queue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitFile(@Nullable PsiFile file) {
        this.queue.clear();
        super.visitFile(file);
    }

    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        if (classOrObject instanceof KtClass && ((KtClass)classOrObject).isData()) {
            return;
        }
        this.queue.push(new ViolationHolder(false, false, 3, null));
        super.visitClassOrObject(classOrObject);
        if (this.queue.pop().violation$detekt_rules()) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)classOrObject), "A class should always override hashCode when overriding equals and the other way around.", null, null, 24, null));
        }
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (!function.isTopLevel()) {
            if (MethodSignatureKt.isEqualsFunction((KtFunction)function)) {
                this.queue.peek().setEquals(true);
            }
            if (MethodSignatureKt.isHashCodeFunction((KtFunction)function)) {
                this.queue.peek().setHashCode(true);
            }
        }
    }

    public EqualsWithHashCodeExist(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("EqualsWithHashCodeExist", Severity.Defect, "Always override hashCode when you override equals. All hash-based collections depend on objects meeting the equals-contract. Two equal objects must produce the same hashcode. When inheriting equals or hashcode, override the inherited and call the super method for clarification.", Debt.Companion.getFIVE_MINS());
        this.queue = new ArrayDeque(5);
    }

    public /* synthetic */ EqualsWithHashCodeExist(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public EqualsWithHashCodeExist() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0002\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0004\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\r\u0010\u0013\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsWithHashCodeExist$ViolationHolder;", "", "equals", "", "hashCode", "(ZZ)V", "getEquals", "()Z", "setEquals", "(Z)V", "getHashCode", "setHashCode", "component1", "component2", "copy", "other", "", "toString", "", "violation", "violation$detekt_rules", "detekt-rules"})
    private static final class ViolationHolder {
        private boolean equals;
        private boolean hashCode;

        public final boolean violation$detekt_rules() {
            return this.equals && !this.hashCode || !this.equals && this.hashCode;
        }

        public final boolean getEquals() {
            return this.equals;
        }

        public final void setEquals(boolean bl) {
            this.equals = bl;
        }

        public final boolean getHashCode() {
            return this.hashCode;
        }

        public final void setHashCode(boolean bl) {
            this.hashCode = bl;
        }

        public ViolationHolder(boolean equals, boolean hashCode) {
            this.equals = equals;
            this.hashCode = hashCode;
        }

        public /* synthetic */ ViolationHolder(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public ViolationHolder() {
            this(false, false, 3, null);
        }

        public final boolean component1() {
            return this.equals;
        }

        public final boolean component2() {
            return this.hashCode;
        }

        @NotNull
        public final ViolationHolder copy(boolean equals, boolean hashCode) {
            return new ViolationHolder(equals, hashCode);
        }

        public static /* synthetic */ ViolationHolder copy$default(ViolationHolder violationHolder, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = violationHolder.equals;
            }
            if ((n & 2) != 0) {
                bl2 = violationHolder.hashCode;
            }
            return violationHolder.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ViolationHolder(equals=" + this.equals + ", hashCode=" + this.hashCode + ")";
        }

        public int hashCode() {
            int n = this.equals ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.hashCode ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ViolationHolder)) break block3;
                    ViolationHolder violationHolder = (ViolationHolder)object;
                    if (this.equals != violationHolder.equals || this.hashCode != violationHolder.hashCode) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

