/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedPatterns", "Lkotlin/text/Regex;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "values", "", "", "visitComment", "", "comment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiComment;", "Companion", "detekt-rules"})
public final class ForbiddenComment
extends Rule {
    @NotNull
    private final Issue issue;
    private final List<String> values;
    private final Regex allowedPatterns;
    @NotNull
    public static final String VALUES = "values";
    @NotNull
    public static final String ALLOWED_PATTERNS = "allowedPatterns";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitComment(@NotNull PsiComment comment) {
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        super.visitComment(comment);
        String text = comment.getText();
        CharSequence charSequence = this.allowedPatterns.getPattern();
        boolean bl = false;
        if (charSequence.length() > 0) {
            String string = text;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            if (this.allowedPatterns.containsMatchIn((CharSequence)string)) {
                return;
            }
        }
        Iterable $this$forEach$iv = this.values;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            String string = text;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            if (!StringsKt.contains((CharSequence)string, (CharSequence)it, (boolean)true)) continue;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)comment), (int)0, (int)2, null), "This comment contains text that has been defined as forbidden in detekt.", null, null, 24, null));
        }
    }

    public ForbiddenComment(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Flags a forbidden comment. Defaults values are TODO:, FIXME: or STOPSHIP:", Debt.Companion.getTEN_MINS());
        this.values = JunkKt.valueOrDefaultCommaSeparated((Config)this, VALUES, CollectionsKt.listOf((Object[])new String[]{"TODO:", "FIXME:", "STOPSHIP:"}));
        this.allowedPatterns = new Regex((String)this.valueOrDefault(ALLOWED_PATTERNS, ""));
    }

    public /* synthetic */ ForbiddenComment(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ForbiddenComment() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Companion;", "", "()V", "ALLOWED_PATTERNS", "", "VALUES", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

