/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\n*\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/LibraryCodeMustSpecifyReturnType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCondition", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "hasExpressionBodyWithoutExplicitReturnType", "detekt-rules"})
public final class LibraryCodeMustSpecifyReturnType
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public boolean visitCondition(@NotNull KtFile root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        return super.visitCondition(root) && this.getFilters() != null;
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (!property.isLocal() && KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)property)) && property.getTypeReference() == null) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), "Library property '" + property.getNameAsSafeName() + "' without explicit return type.", null, null, 24, null));
        }
        super.visitProperty(property);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (!function.isLocal() && KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)function)) && this.hasExpressionBodyWithoutExplicitReturnType(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "Library function '" + function.getNameAsSafeName() + "' without explicit return type.", null, null, 24, null));
        }
        super.visitNamedFunction(function);
    }

    private final boolean hasExpressionBodyWithoutExplicitReturnType(@NotNull KtNamedFunction $this$hasExpressionBodyWithoutExplicitReturnType) {
        return $this$hasExpressionBodyWithoutExplicitReturnType.getEqualsToken() != null && !$this$hasExpressionBodyWithoutExplicitReturnType.hasDeclaredReturnType();
    }

    public LibraryCodeMustSpecifyReturnType(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Library functions/properties should have an explicit return type. Inferred return type can easily be changed by mistake which may lead to breaking changes.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ LibraryCodeMustSpecifyReturnType(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public LibraryCodeMustSpecifyReturnType() {
        this(null, 1, null);
    }
}

