/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010#\u001a\u00020\u0006*\u00020$H\u0002J\f\u0010%\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010&\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010'\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010(\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010)\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010*\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010+\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010,\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010-\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010.\u001a\u00020\u0006*\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00060"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MagicNumber;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreAnnotation", "", "ignoreCompanionObjectPropertyDeclaration", "ignoreConstantDeclaration", "ignoreEnums", "ignoreHashCodeFunction", "ignoreLocalVariables", "ignoreNamedArgument", "ignorePropertyDeclaration", "ignoreRanges", "ignoredNumbers", "", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isIgnoredByConfig", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "normalizeForParsingAsDouble", "", "text", "parseAsDouble", "rawNumber", "parseAsDoubleOrNull", "rawToken", "(Ljava/lang/String;)Ljava/lang/Double;", "visitConstantExpression", "", "hasUnaryMinusPrefix", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isCompanionObjectProperty", "isConstantProperty", "isInCompanionObject", "isLocalProperty", "isNamedArgument", "isPartOfConstructorOrFunctionConstant", "isPartOfFunctionReturnConstant", "isPartOfHashCode", "isPartOfRange", "isProperty", "Companion", "detekt-rules"})
public final class MagicNumber
extends Rule {
    @NotNull
    private final Issue issue;
    private final List<Double> ignoredNumbers;
    private final boolean ignoreAnnotation;
    private final boolean ignoreHashCodeFunction;
    private final boolean ignorePropertyDeclaration;
    private final boolean ignoreLocalVariables;
    private final boolean ignoreNamedArgument;
    private final boolean ignoreEnums;
    private final boolean ignoreConstantDeclaration;
    private final boolean ignoreCompanionObjectPropertyDeclaration;
    private final boolean ignoreRanges;
    @NotNull
    public static final String IGNORE_NUMBERS = "ignoreNumbers";
    @NotNull
    public static final String IGNORE_HASH_CODE = "ignoreHashCodeFunction";
    @NotNull
    public static final String IGNORE_PROPERTY_DECLARATION = "ignorePropertyDeclaration";
    @NotNull
    public static final String IGNORE_LOCAL_VARIABLES = "ignoreLocalVariableDeclaration";
    @NotNull
    public static final String IGNORE_CONSTANT_DECLARATION = "ignoreConstantDeclaration";
    @NotNull
    public static final String IGNORE_COMPANION_OBJECT_PROPERTY_DECLARATION = "ignoreCompanionObjectPropertyDeclaration";
    @NotNull
    public static final String IGNORE_ANNOTATION = "ignoreAnnotation";
    @NotNull
    public static final String IGNORE_NAMED_ARGUMENT = "ignoreNamedArgument";
    @NotNull
    public static final String IGNORE_ENUMS = "ignoreEnums";
    @NotNull
    public static final String IGNORE_RANGES = "ignoreRanges";
    private static final int HEX_RADIX = 16;
    private static final int BINARY_RADIX = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitConstantExpression(@NotNull KtConstantExpression expression) {
        PsiElement parent;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (this.isIgnoredByConfig(expression) || this.isPartOfFunctionReturnConstant(expression) || this.isPartOfConstructorOrFunctionConstant(expression)) {
            return;
        }
        PsiElement psiElement = parent = expression.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
        String rawNumber = this.hasUnaryMinusPrefix(psiElement) ? parent.getText() : expression.getText();
        Double d = this.parseAsDoubleOrNull(rawNumber);
        if (d == null) {
            return;
        }
        double number = d;
        if (!this.ignoredNumbers.contains(number)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This expression contains a magic number. Consider defining it to a well named constant.", null, null, 24, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIgnoredByConfig(KtConstantExpression expression) {
        boolean $i$f$getNonStrictParentOfType;
        PsiElement $this$getNonStrictParentOfType$iv$iv;
        boolean $i$f$isPartOf;
        PsiElement $this$isPartOf$iv;
        if (this.ignorePropertyDeclaration && this.isProperty(expression)) {
            return true;
        }
        if (this.ignoreLocalVariables && this.isLocalProperty(expression)) {
            return true;
        }
        if (this.ignoreConstantDeclaration && this.isConstantProperty(expression)) {
            return true;
        }
        if (this.ignoreCompanionObjectPropertyDeclaration && this.isCompanionObjectProperty(expression)) {
            return true;
        }
        if (this.ignoreAnnotation) {
            $this$isPartOf$iv = (PsiElement)expression;
            $i$f$isPartOf = false;
            $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtAnnotationEntry.class, (boolean)false) != null) {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
        }
        if (this.ignoreHashCodeFunction && this.isPartOfHashCode(expression)) {
            return true;
        }
        if (this.ignoreEnums) {
            $this$isPartOf$iv = (PsiElement)expression;
            $i$f$isPartOf = false;
            $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtEnumEntry.class, (boolean)false) != null) {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
        }
        if (this.ignoreNamedArgument && this.isNamedArgument(expression)) {
            return true;
        }
        if (!this.ignoreRanges) return false;
        if (!this.isPartOfRange(expression)) return false;
        return true;
    }

    private final Double parseAsDoubleOrNull(String rawToken) {
        String string;
        try {
            Double d;
            String string2 = rawToken;
            if (string2 != null) {
                string = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                d = this.parseAsDouble(it);
            } else {
                d = null;
            }
            string = d;
        }
        catch (NumberFormatException e) {
            string = null;
        }
        return string;
    }

    private final double parseAsDouble(String rawNumber) {
        double d;
        String normalizedText = this.normalizeForParsingAsDouble(rawNumber);
        if (StringsKt.startsWith$default((String)normalizedText, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)normalizedText, (String)"0X", (boolean)false, (int)2, null)) {
            String string = normalizedText;
            int n = 2;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            string = string3;
            n = 16;
            bl = false;
            d = Long.parseLong(string, CharsKt.checkRadix((int)n));
        } else if (StringsKt.startsWith$default((String)normalizedText, (String)"0b", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)normalizedText, (String)"0B", (boolean)false, (int)2, null)) {
            String string = normalizedText;
            int n = 2;
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string = string5;
            n = 2;
            bl = false;
            d = Long.parseLong(string, CharsKt.checkRadix((int)n));
        } else {
            String string = normalizedText;
            boolean bl = false;
            d = Double.parseDouble(string);
        }
        return d;
    }

    private final String normalizeForParsingAsDouble(String text) {
        String string = text;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        boolean bl2 = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.replace$default((String)string4, (String)"_", (String)"", (boolean)false, (int)4, null), (CharSequence)"l"), (CharSequence)"d"), (CharSequence)"f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNamedArgument(@NotNull KtConstantExpression $this$isNamedArgument) {
        KtValueArgument valueArgument;
        PsiElement psiElement;
        PsiElement psiElement2;
        PsiElement psiElement3 = $this$isNamedArgument.getParent();
        if (psiElement3 instanceof KtPrefixExpression) {
            PsiElement psiElement4 = $this$isNamedArgument.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"parent");
            psiElement2 = psiElement4.getParent();
        } else {
            psiElement2 = psiElement = $this$isNamedArgument.getParent();
        }
        if (!(psiElement2 instanceof KtValueArgument)) {
            psiElement = null;
        }
        KtValueArgument ktValueArgument = valueArgument = (KtValueArgument)psiElement;
        if (ktValueArgument == null) return false;
        if (!ktValueArgument.isNamed()) return false;
        PsiElement $this$isPartOf$iv = (PsiElement)$this$isNamedArgument;
        boolean $i$f$isPartOf = false;
        PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
        boolean $i$f$getNonStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtCallElement.class, (boolean)false) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfFunctionReturnConstant(@NotNull KtConstantExpression $this$isPartOfFunctionReturnConstant) {
        if ($this$isPartOfFunctionReturnConstant.getParent() instanceof KtNamedFunction) return true;
        if (!($this$isPartOfFunctionReturnConstant.getParent() instanceof KtReturnExpression)) return false;
        PsiElement psiElement = $this$isPartOfFunctionReturnConstant.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
        PsiElement psiElement2 = psiElement.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent.parent");
        if (psiElement2.getChildren().length != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfConstructorOrFunctionConstant(@NotNull KtConstantExpression $this$isPartOfConstructorOrFunctionConstant) {
        if (!($this$isPartOfConstructorOrFunctionConstant.getParent() instanceof KtParameter)) return false;
        PsiElement psiElement = $this$isPartOfConstructorOrFunctionConstant.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
        PsiElement psiElement2 = psiElement.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent.parent");
        PsiElement psiElement3 = psiElement2.getParent();
        if (psiElement3 instanceof KtNamedFunction || psiElement3 instanceof KtPrimaryConstructor) return true;
        if (!(psiElement3 instanceof KtSecondaryConstructor)) return false;
        return true;
    }

    private final boolean isPartOfRange(@NotNull KtConstantExpression $this$isPartOfRange) {
        PsiElement theParent = $this$isPartOfRange.getParent();
        Set rangeOperators = SetsKt.setOf((Object[])new String[]{"downTo", "until", "step"});
        return theParent instanceof KtBinaryExpression ? Intrinsics.areEqual((Object)((KtBinaryExpression)theParent).getOperationToken(), (Object)KtTokens.RANGE) || rangeOperators.contains(((KtBinaryExpression)theParent).getOperationReference().getReferencedName()) : false;
    }

    private final boolean isPartOfHashCode(@NotNull KtConstantExpression $this$isPartOfHashCode) {
        KtNamedFunction containingFunction;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isPartOfHashCode;
        boolean $i$f$getNonStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = containingFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedFunction.class, (boolean)false);
        return ktNamedFunction != null && MethodSignatureKt.isHashCodeFunction((KtFunction)ktNamedFunction);
    }

    private final boolean isLocalProperty(@NotNull KtConstantExpression $this$isLocalProperty) {
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isLocalProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtProperty.class, (boolean)false);
        return ktProperty != null ? ktProperty.isLocal() : false;
    }

    private final boolean isProperty(@NotNull KtConstantExpression $this$isProperty) {
        boolean bl;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtProperty.class, (boolean)false);
        if (ktProperty != null) {
            KtProperty ktProperty2 = ktProperty;
            boolean bl2 = false;
            boolean bl3 = false;
            KtProperty it = ktProperty2;
            boolean bl4 = false;
            bl = !it.isLocal();
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCompanionObjectProperty(@NotNull KtConstantExpression $this$isCompanionObjectProperty) {
        return this.isProperty($this$isCompanionObjectProperty) && this.isInCompanionObject($this$isCompanionObjectProperty);
    }

    private final boolean isInCompanionObject(@NotNull KtConstantExpression $this$isInCompanionObject) {
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isInCompanionObject;
        boolean $i$f$getNonStrictParentOfType = false;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)false);
        return ktObjectDeclaration != null ? ktObjectDeclaration.isCompanion() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConstantProperty(@NotNull KtConstantExpression $this$isConstantProperty) {
        if (!this.isProperty($this$isConstantProperty)) return false;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isConstantProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtProperty.class, (boolean)false);
        if (ktProperty == null) return false;
        boolean bl = KtModifierListKt.isConstant((KtModifierListOwner)ktProperty);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUnaryMinusPrefix(@NotNull PsiElement $this$hasUnaryMinusPrefix) {
        if (!($this$hasUnaryMinusPrefix instanceof KtPrefixExpression)) return false;
        PsiElement psiElement = ((KtPrefixExpression)$this$hasUnaryMinusPrefix).getFirstChild();
        if (!(psiElement instanceof KtOperationReferenceExpression)) {
            psiElement = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement;
        if (!Intrinsics.areEqual((Object)(ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getOperationSignTokenType() : null), (Object)KtTokens.MINUS)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public MagicNumber(@NotNull Config config) {
        Collection<Double> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Report magic numbers. Magic number is a numeric literal that is not defined as a constant and hence it's unclear what the purpose of this number is. It's better to declare such numbers as constants and give them a proper name. By default, -1, 0, 1, and 2 are not considered to be magic numbers.", Debt.Companion.getTEN_MINS());
        Iterable iterable = JunkKt.valueOrDefaultCommaSeparated((Config)this, IGNORE_NUMBERS, CollectionsKt.listOf((Object[])new String[]{"-1", "0", "1", "2"}));
        MagicNumber magicNumber = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Double d = this.parseAsDouble((String)it);
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        magicNumber.ignoredNumbers = CollectionsKt.sorted((Iterable)collection);
        this.ignoreAnnotation = (Boolean)this.valueOrDefault(IGNORE_ANNOTATION, false);
        this.ignoreHashCodeFunction = (Boolean)this.valueOrDefault(IGNORE_HASH_CODE, true);
        this.ignorePropertyDeclaration = (Boolean)this.valueOrDefault(IGNORE_PROPERTY_DECLARATION, false);
        this.ignoreLocalVariables = (Boolean)this.valueOrDefault(IGNORE_LOCAL_VARIABLES, false);
        this.ignoreNamedArgument = (Boolean)this.valueOrDefault(IGNORE_NAMED_ARGUMENT, false);
        this.ignoreEnums = (Boolean)this.valueOrDefault(IGNORE_ENUMS, false);
        this.ignoreConstantDeclaration = (Boolean)this.valueOrDefault(IGNORE_CONSTANT_DECLARATION, true);
        this.ignoreCompanionObjectPropertyDeclaration = (Boolean)this.valueOrDefault(IGNORE_COMPANION_OBJECT_PROPERTY_DECLARATION, true);
        this.ignoreRanges = (Boolean)this.valueOrDefault(IGNORE_RANGES, false);
    }

    public /* synthetic */ MagicNumber(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MagicNumber() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MagicNumber$Companion;", "", "()V", "BINARY_RADIX", "", "HEX_RADIX", "IGNORE_ANNOTATION", "", "IGNORE_COMPANION_OBJECT_PROPERTY_DECLARATION", "IGNORE_CONSTANT_DECLARATION", "IGNORE_ENUMS", "IGNORE_HASH_CODE", "IGNORE_LOCAL_VARIABLES", "IGNORE_NAMED_ARGUMENT", "IGNORE_NUMBERS", "IGNORE_PROPERTY_DECLARATION", "IGNORE_RANGES", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

