/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.internal.GrpcAttributes;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;

public final class GoogleDefaultProtocolNegotiator
implements InternalProtocolNegotiator.ProtocolNegotiator {
    private final InternalProtocolNegotiator.ProtocolNegotiator altsProtocolNegotiator;
    private final InternalProtocolNegotiator.ProtocolNegotiator tlsProtocolNegotiator;

    public GoogleDefaultProtocolNegotiator(TsiHandshakerFactory altsFactory, AltsProtocolNegotiator.LazyChannel lazyHandshakerChannel, SslContext sslContext) {
        this.altsProtocolNegotiator = AltsProtocolNegotiator.createClientNegotiator(altsFactory, lazyHandshakerChannel);
        this.tlsProtocolNegotiator = InternalProtocolNegotiators.tls((SslContext)sslContext);
    }

    public AsciiString scheme() {
        assert (this.tlsProtocolNegotiator.scheme().equals((Object)this.altsProtocolNegotiator.scheme()));
        return this.tlsProtocolNegotiator.scheme();
    }

    @VisibleForTesting
    GoogleDefaultProtocolNegotiator(InternalProtocolNegotiator.ProtocolNegotiator altsProtocolNegotiator, InternalProtocolNegotiator.ProtocolNegotiator tlsProtocolNegotiator) {
        this.altsProtocolNegotiator = altsProtocolNegotiator;
        this.tlsProtocolNegotiator = tlsProtocolNegotiator;
    }

    public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
        if (grpcHandler.getEagAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) != null || grpcHandler.getEagAttributes().get(GrpcAttributes.ATTR_LB_PROVIDED_BACKEND) != null) {
            return this.altsProtocolNegotiator.newHandler(grpcHandler);
        }
        return this.tlsProtocolNegotiator.newHandler(grpcHandler);
    }

    public void close() {
        this.altsProtocolNegotiator.close();
        this.tlsProtocolNegotiator.close();
    }
}

