/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import com.google.common.collect.ImmutableList;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.Status;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class FakeNameResolverProvider
extends NameResolverProvider {
    private final URI targetUri;
    private final SocketAddress address;

    public FakeNameResolverProvider(String targetUri, SocketAddress address) {
        this.targetUri = URI.create(targetUri);
        this.address = address;
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (targetUri.equals(this.targetUri)) {
            return new FakeNameResolver(this.address);
        }
        return null;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 10;
    }

    public String getDefaultScheme() {
        return this.targetUri.getScheme();
    }

    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(this.address.getClass());
    }

    private static final class FakeNameResolver
    extends NameResolver {
        private static final String AUTHORITY = "fake-authority";
        private final SocketAddress address;
        private volatile boolean shutdown;

        private FakeNameResolver(SocketAddress address) {
            this.address = address;
        }

        public void start(NameResolver.Listener2 listener) {
            if (this.shutdown) {
                listener.onError(Status.FAILED_PRECONDITION.withDescription("Resolver is shutdown"));
            } else {
                listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses((List)ImmutableList.of((Object)new EquivalentAddressGroup(this.address))).build());
            }
        }

        public String getServiceAuthority() {
            return AUTHORITY;
        }

        public void shutdown() {
            this.shutdown = true;
        }
    }
}

