/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import io.gsonfire.ClassConfig;
import io.gsonfire.DateSerializationPolicy;
import io.gsonfire.PostProcessor;
import io.gsonfire.PreProcessor;
import io.gsonfire.TypeSelector;
import io.gsonfire.gson.EnumDefaultValueTypeAdapterFactory;
import io.gsonfire.gson.ExcludeByValueTypeAdapterFactory;
import io.gsonfire.gson.FireExclusionStrategy;
import io.gsonfire.gson.FireExclusionStrategyComposite;
import io.gsonfire.gson.FireTypeAdapterFactory;
import io.gsonfire.gson.SimpleIterableTypeAdapterFactory;
import io.gsonfire.gson.TypeSelectorTypeAdapterFactory;
import io.gsonfire.gson.WrapTypeAdapterFactory;
import io.gsonfire.postprocessors.MergeMapPostProcessor;
import io.gsonfire.postprocessors.methodinvoker.MethodInvokerPostProcessor;
import io.gsonfire.util.Mapper;
import io.gsonfire.util.reflection.CachedReflectionFactory;
import io.gsonfire.util.reflection.Factory;
import io.gsonfire.util.reflection.FieldInspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class GsonFireBuilder {
    private final Map<Class, ClassConfig> classConfigMap = new HashMap<Class, ClassConfig>();
    private final Map<Class, Mapper> wrappedClasses = new HashMap<Class, Mapper>();
    private final List<Class> orderedClasses = new ArrayList<Class>();
    private final List<FireExclusionStrategy> serializationExclusions = new ArrayList<FireExclusionStrategy>();
    private final FieldInspector fieldInspector = new FieldInspector();
    private final Factory factory = new CachedReflectionFactory();
    private final Map<Class, Enum> enumDefaultValues = new HashMap<Class, Enum>();
    private DateSerializationPolicy dateSerializationPolicy;
    private boolean dateDeserializationStrict = true;
    private TimeZone serializeTimeZone = TimeZone.getDefault();
    private boolean enableExposeMethodResults = false;
    private boolean enableExclusionByValueStrategies = false;

    private ClassConfig getClassConfig(Class clazz) {
        ClassConfig result = this.classConfigMap.get(clazz);
        if (result == null) {
            result = new ClassConfig(clazz);
            this.classConfigMap.put(clazz, result);
            GsonFireBuilder.insertOrdered(this.orderedClasses, clazz);
        }
        return result;
    }

    private static void insertOrdered(List<Class> classes, Class clazz) {
        for (int i = classes.size() - 1; i >= 0; --i) {
            Class current = classes.get(i);
            if (!current.isAssignableFrom(clazz)) continue;
            classes.add(i + 1, clazz);
            return;
        }
        classes.add(0, clazz);
    }

    public <T> GsonFireBuilder registerTypeSelector(Class<T> clazz, TypeSelector<T> factory) {
        ClassConfig config = this.getClassConfig(clazz);
        config.setTypeSelector(factory);
        return this;
    }

    public <T> GsonFireBuilder registerPostProcessor(Class<T> clazz, PostProcessor<? super T> postProcessor) {
        ClassConfig config = this.getClassConfig(clazz);
        config.getPostProcessors().add(postProcessor);
        return this;
    }

    public <T> GsonFireBuilder registerPreProcessor(Class<T> clazz, PreProcessor<? super T> preProcessor) {
        ClassConfig config = this.getClassConfig(clazz);
        config.getPreProcessors().add(preProcessor);
        return this;
    }

    public GsonFireBuilder dateSerializationPolicy(DateSerializationPolicy policy) {
        this.dateSerializationPolicy = policy;
        return this;
    }

    public <T> GsonFireBuilder wrap(Class<T> clazz, final String name) {
        this.wrap(clazz, new Mapper<T, String>(){

            @Override
            public String map(Object from) {
                return name;
            }
        });
        return this;
    }

    public <T> GsonFireBuilder wrap(Class<T> clazz, Mapper<T, String> mapper) {
        this.wrappedClasses.put(clazz, mapper);
        return this;
    }

    public GsonFireBuilder enableExposeMethodResult() {
        this.enableExposeMethodResults = true;
        return this;
    }

    public GsonFireBuilder enableExclusionByValue() {
        this.enableExclusionByValueStrategies = true;
        return this;
    }

    public GsonFireBuilder enableHooks(Class clazz) {
        ClassConfig config = this.getClassConfig(clazz);
        config.setHooksEnabled(true);
        return this;
    }

    @Deprecated
    public GsonFireBuilder enableMergeMaps(Class clazz) {
        this.registerPostProcessor(clazz, new MergeMapPostProcessor(this.fieldInspector));
        return this;
    }

    public GsonFireBuilder serializeTimeZone(TimeZone timeZone) {
        this.serializeTimeZone = timeZone;
        return this;
    }

    public <T extends Enum> GsonFireBuilder enumDefaultValue(Class<T> enumClass, T defaultValue) {
        this.enumDefaultValues.put(enumClass, defaultValue);
        return this;
    }

    public GsonFireBuilder addSerializationExclusionStrategy(FireExclusionStrategy exclusionStrategy) {
        this.serializationExclusions.add(exclusionStrategy);
        return this;
    }

    public GsonBuilder createGsonBuilder() {
        Set<TypeToken> alreadyResolvedTypeTokensRegistry = Collections.newSetFromMap(new ConcurrentHashMap());
        GsonBuilder builder = new GsonBuilder();
        if (this.enableExposeMethodResults) {
            FireExclusionStrategyComposite compositeExclusionStrategy = new FireExclusionStrategyComposite(this.serializationExclusions);
            this.registerPostProcessor(Object.class, new MethodInvokerPostProcessor(compositeExclusionStrategy));
        }
        if (this.enableExclusionByValueStrategies) {
            builder.registerTypeAdapterFactory((TypeAdapterFactory)new ExcludeByValueTypeAdapterFactory(this.fieldInspector, this.factory));
        }
        for (Class clazz : this.orderedClasses) {
            ClassConfig config = this.classConfigMap.get(clazz);
            if (config.getTypeSelector() != null) {
                builder.registerTypeAdapterFactory(new TypeSelectorTypeAdapterFactory(config, alreadyResolvedTypeTokensRegistry));
            }
            builder.registerTypeAdapterFactory(new FireTypeAdapterFactory(config));
        }
        for (Map.Entry entry : this.enumDefaultValues.entrySet()) {
            builder.registerTypeAdapterFactory(new EnumDefaultValueTypeAdapterFactory<Enum>((Class)entry.getKey(), (Enum)entry.getValue()));
        }
        if (this.dateSerializationPolicy != null) {
            builder.registerTypeAdapter(Date.class, this.dateSerializationPolicy.createTypeAdapter(this.serializeTimeZone));
        }
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new SimpleIterableTypeAdapterFactory());
        builder.registerTypeAdapterFactory(new WrapTypeAdapterFactory(this.wrappedClasses));
        return builder;
    }

    public Gson createGson() {
        return this.createGsonBuilder().create();
    }
}

