/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hosts {
    private static final transient Logger LOG = LoggerFactory.getLogger(Hosts.class);
    public static final String PREFERED_ADDRESS_PROPERTY_NAME = "preferred.network.address";

    private Hosts() {
    }

    public static Map<String, Set<InetAddress>> getNetworkInterfaceAddresses(boolean includeLoopback) {
        TreeMap<String, Set<InetAddress>> interfaceAddressMap = new TreeMap<String, Set<InetAddress>>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp() || !includeLoopback && iface.isLoopback()) continue;
                String name = iface.getName();
                Enumeration<InetAddress> ifaceAdresses = iface.getInetAddresses();
                while (ifaceAdresses.hasMoreElements()) {
                    InetAddress ia = ifaceAdresses.nextElement();
                    if (!includeLoopback && ia.isLoopbackAddress() || ia.getHostAddress().contains(":") || name != null && name.toLowerCase().contains("docker")) continue;
                    LinkedHashSet<InetAddress> addresses = (LinkedHashSet<InetAddress>)interfaceAddressMap.get(name);
                    if (addresses == null) {
                        addresses = new LinkedHashSet<InetAddress>();
                    }
                    addresses.add(ia);
                    interfaceAddressMap.put(name, addresses);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return interfaceAddressMap;
    }

    public static Set<InetAddress> getAddresses() {
        LinkedHashSet<InetAddress> allAddresses = new LinkedHashSet<InetAddress>();
        Map<String, Set<InetAddress>> interfaceAddressMap = Hosts.getNetworkInterfaceAddresses(false);
        for (Map.Entry<String, Set<InetAddress>> entry : interfaceAddressMap.entrySet()) {
            Set<InetAddress> addresses = entry.getValue();
            if (addresses.isEmpty()) continue;
            for (InetAddress address : addresses) {
                allAddresses.add(address);
            }
        }
        return allAddresses;
    }

    private static InetAddress chooseAddress(String preferred) throws UnknownHostException {
        Set<InetAddress> addresses = Hosts.getAddresses();
        if (preferred != null && !preferred.isEmpty()) {
            try {
                InetAddress preferredAddress = InetAddress.getByName(preferred);
                if (addresses != null && addresses.contains(preferredAddress)) {
                    LOG.info("preferred address is " + preferredAddress.getHostAddress() + " for host " + preferredAddress.getHostName());
                    return preferredAddress;
                }
            }
            catch (UnknownHostException preferredAddress) {
                // empty catch block
            }
            for (InetAddress address : addresses) {
                if (!preferred.equals(address.getHostName())) continue;
                return address;
            }
            StringBuffer hostNameBuffer = new StringBuffer();
            for (InetAddress address : addresses) {
                if (hostNameBuffer.length() > 0) {
                    hostNameBuffer.append(", ");
                }
                hostNameBuffer.append(address.getHostName() + "/" + address.getHostAddress());
            }
            LOG.warn("Could not find network address for preferred '" + preferred + "' when the addresses were: " + hostNameBuffer);
        }
        if (addresses.contains(InetAddress.getLocalHost())) {
            return InetAddress.getLocalHost();
        }
        if (addresses != null && !addresses.isEmpty()) {
            return addresses.toArray(new InetAddress[addresses.size()])[0];
        }
        return InetAddress.getLocalHost();
    }

    public static String getLocalHostName() throws UnknownHostException {
        String preffered = System.getProperty(PREFERED_ADDRESS_PROPERTY_NAME);
        return Hosts.chooseAddress(preffered).getHostName();
    }

    public static String getLocalIp() throws UnknownHostException {
        String preffered = System.getProperty(PREFERED_ADDRESS_PROPERTY_NAME);
        return Hosts.chooseAddress(preffered).getHostAddress();
    }
}

